/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.maximize;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.uberfire.client.resources.i18n.WorkbenchConstants;
import org.uberfire.client.workbench.panels.MaximizeToggleButtonPresenter;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.mvp.Command;

public class MaximizeToggleButton
extends Button
implements MaximizeToggleButtonPresenter.View {
    private MaximizeToggleButtonPresenter presenter;
    private boolean maximized;
    private Command maximizeCommand;
    private Command unmaximizeCommand;

    public MaximizeToggleButton() {
        this.setMaximized(this.maximized);
        this.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                MaximizeToggleButton.this.presenter.handleClick();
            }
        });
        this.setSize(ButtonSize.SMALL);
    }

    public HandlerRegistration addClickHandler(ClickHandler handler) {
        return this.addDomHandler((EventHandler)handler, ClickEvent.getType());
    }

    public void init(MaximizeToggleButtonPresenter presenter) {
        this.presenter = (MaximizeToggleButtonPresenter)PortablePreconditions.checkNotNull((String)"presenter", (Object)presenter);
    }

    public void click() {
        boolean wasMaximized = this.maximized;
        this.setMaximized(!wasMaximized);
        if (wasMaximized) {
            if (this.unmaximizeCommand != null) {
                this.unmaximizeCommand.execute();
            }
        } else if (this.maximizeCommand != null) {
            this.maximizeCommand.execute();
        }
    }

    public Command getMaximizeCommand() {
        return this.maximizeCommand;
    }

    public void setMaximizeCommand(Command maximizeCommand) {
        this.maximizeCommand = maximizeCommand;
    }

    public Command getUnmaximizeCommand() {
        return this.unmaximizeCommand;
    }

    public void setUnmaximizeCommand(Command unmaximizeCommand) {
        this.unmaximizeCommand = unmaximizeCommand;
    }

    public boolean isMaximized() {
        return this.maximized;
    }

    public void setMaximized(boolean maximized) {
        this.maximized = maximized;
        if (maximized) {
            this.setIcon(IconType.COMPRESS);
            this.setTitle(WorkbenchConstants.INSTANCE.minimizePanel());
        } else {
            this.setIcon(IconType.EXPAND);
            this.setTitle(WorkbenchConstants.INSTANCE.maximizePanel());
        }
    }
}

