/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.authz;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.client.authz.PerspectiveAction;
import org.uberfire.client.mvp.AbstractWorkbenchPerspectiveActivity;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.resources.i18n.PermissionTreeI18n;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceAction;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.security.client.authz.tree.LoadCallback;
import org.uberfire.security.client.authz.tree.LoadOptions;
import org.uberfire.security.client.authz.tree.PermissionNode;
import org.uberfire.security.client.authz.tree.PermissionTreeProvider;
import org.uberfire.security.client.authz.tree.impl.PermissionLeafNode;
import org.uberfire.security.client.authz.tree.impl.PermissionResourceNode;
import org.uberfire.workbench.model.ActivityResourceType;

@ApplicationScoped
public class PerspectiveTreeProvider
implements PermissionTreeProvider {
    private SyncBeanManager iocManager;
    private PermissionManager permissionManager;
    private PermissionTreeI18n i18n;
    private boolean active = true;
    private String resourceName = null;
    private String rootNodeName = null;
    private int rootNodePosition = 0;
    private Map<String, String> perspectiveNameMap = new HashMap<String, String>();
    private Set<String> perspectiveIdsExcluded = new HashSet<String>();

    public PerspectiveTreeProvider() {
    }

    @Inject
    public PerspectiveTreeProvider(SyncBeanManager iocManager, PermissionManager permissionManager, PermissionTreeI18n i18n) {
        this.iocManager = iocManager;
        this.permissionManager = permissionManager;
        this.i18n = i18n;
        this.resourceName = i18n.perspectiveResourceName();
        this.rootNodeName = i18n.perspectivesNodeName();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getRootNodeName() {
        return this.rootNodeName;
    }

    public void setRootNodeName(String rootNodeName) {
        this.rootNodeName = rootNodeName;
    }

    public int getRootNodePosition() {
        return this.rootNodePosition;
    }

    public void setRootNodePosition(int rootNodePosition) {
        this.rootNodePosition = rootNodePosition;
    }

    public void excludePerspectiveId(String perspectiveId) {
        this.perspectiveIdsExcluded.add(perspectiveId);
    }

    public Set<String> getPerspectiveIdsExcluded() {
        return this.perspectiveIdsExcluded;
    }

    public PermissionNode buildRootNode() {
        PermissionResourceNode rootNode = new PermissionResourceNode(this.resourceName, (PermissionTreeProvider)this);
        rootNode.setNodeName(this.rootNodeName);
        rootNode.setNodeFullName(this.i18n.perspectivesNodeHelp());
        rootNode.setPositionInTree(this.rootNodePosition);
        Permission readPermission = this.newPermission(PerspectiveAction.READ);
        Permission updatePermission = this.newPermission(PerspectiveAction.UPDATE);
        Permission deletePermission = this.newPermission(PerspectiveAction.DELETE);
        Permission createPermission = this.newPermission(PerspectiveAction.CREATE);
        rootNode.addPermission(readPermission, this.i18n.perspectiveRead());
        rootNode.addPermission(updatePermission, this.i18n.perspectiveUpdate());
        rootNode.addPermission(deletePermission, this.i18n.perspectiveDelete());
        rootNode.addPermission(createPermission, this.i18n.perspectiveCreate());
        rootNode.addDependencies(readPermission, new Permission[]{updatePermission, deletePermission});
        return rootNode;
    }

    public void loadChildren(PermissionNode parent, LoadOptions options, LoadCallback callback) {
        if (parent.getNodeName().equals(this.rootNodeName)) {
            callback.afterLoad(this.buildPerspectiveNodes(options));
        }
    }

    private Permission newPermission(ResourceAction action) {
        return this.permissionManager.createPermission((ResourceType)ActivityResourceType.PERSPECTIVE, action, true);
    }

    private Permission newPermission(Resource resource, ResourceAction action) {
        return this.permissionManager.createPermission(resource, action, true);
    }

    private List<PermissionNode> buildPerspectiveNodes(LoadOptions options) {
        ArrayList<PermissionNode> nodes = new ArrayList<PermissionNode>();
        for (SyncBeanDef beanDef : this.iocManager.lookupBeans(PerspectiveActivity.class)) {
            PerspectiveActivity p = (PerspectiveActivity)beanDef.getInstance();
            if (!this.match((Resource)p, options)) continue;
            nodes.add(this.toPerspectiveNode(p));
        }
        int max = options.getMaxNodes();
        return max > 0 && max < nodes.size() ? nodes.subList(0, max) : nodes;
    }

    private PermissionNode toPerspectiveNode(PerspectiveActivity p) {
        String id = p.getIdentifier();
        String name = this.getPerspectiveName(id);
        PermissionLeafNode node = new PermissionLeafNode();
        node.setNodeName(name);
        Permission readPermission = this.newPermission((Resource)p, PerspectiveAction.READ);
        node.addPermission(readPermission, this.i18n.perspectiveRead());
        if (!(p instanceof AbstractWorkbenchPerspectiveActivity)) {
            Permission updatePermission = this.newPermission((Resource)p, PerspectiveAction.UPDATE);
            Permission deletePermission = this.newPermission((Resource)p, PerspectiveAction.DELETE);
            node.addPermission(updatePermission, this.i18n.perspectiveUpdate());
            node.addPermission(deletePermission, this.i18n.perspectiveDelete());
            node.addDependencies(readPermission, new Permission[]{updatePermission, deletePermission});
        }
        return node;
    }

    public String getPerspectiveName(String perspectiveId) {
        if (this.perspectiveNameMap.containsKey(perspectiveId)) {
            return this.perspectiveNameMap.get(perspectiveId);
        }
        int lastDot = perspectiveId.lastIndexOf(".");
        return lastDot != -1 ? perspectiveId.substring(lastDot + 1) : perspectiveId;
    }

    public void setPerspectiveName(String perspectiveId, String name) {
        this.perspectiveNameMap.put(perspectiveId, name);
    }

    private boolean match(Resource r, LoadOptions options) {
        String perspectiveName;
        String namePattern = options.getNodeNamePattern();
        Collection includedIds = options.getResourceIds();
        if (this.perspectiveIdsExcluded.contains(r.getIdentifier())) {
            return false;
        }
        if (includedIds != null && !includedIds.isEmpty() && includedIds.contains(r.getIdentifier())) {
            return true;
        }
        return namePattern != null && (perspectiveName = this.getPerspectiveName(r.getIdentifier())).toLowerCase().contains(namePattern.toLowerCase());
    }
}

