/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.impl.authz;

import org.uberfire.security.Resource;
import org.uberfire.security.ResourceAction;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionType;
import org.uberfire.security.impl.authz.DotNamedPermission;

public class DotNamedPermissionType
implements PermissionType {
    private String type = null;

    public DotNamedPermissionType(String type) {
        this.type = type;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public boolean supportsPermission(String name) {
        return name == null || name.startsWith(this.type);
    }

    @Override
    public Permission createPermission(String name, boolean granted) {
        if (!this.supportsPermission(name)) {
            throw new IllegalArgumentException("The permission is not supported: " + name);
        }
        return new DotNamedPermission(name, granted);
    }

    @Override
    public Permission createPermission(ResourceType resourceType, ResourceAction action, boolean granted) {
        ResourceAction _action = action != null ? action : ResourceAction.READ;
        String name = this.buildPermissionName(resourceType, _action.getName().toLowerCase(), null);
        return this.createPermission(name, granted);
    }

    @Override
    public Permission createPermission(Resource resource, ResourceAction action, boolean granted) {
        ResourceAction _action = action != null ? action : ResourceAction.READ;
        ResourceType type = resource != null ? resource.getResourceType() : null;
        String id = resource != null ? resource.getIdentifier() : null;
        String name = this.buildPermissionName(type, _action.getName().toLowerCase(), id);
        return this.createPermission(name, granted);
    }

    @Override
    public String resolveResourceId(Permission permission) {
        String[] s;
        String name;
        String string = name = permission != null ? permission.getName() : null;
        if (name != null && (s = name.split("\\.")).length > 2) {
            String prefix = s[0] + "." + s[1] + ".";
            return name.substring(prefix.length());
        }
        return null;
    }

    protected String buildPermissionName(ResourceType type, String action, String resourceId) {
        String name = "";
        if (type != null && !type.getName().equalsIgnoreCase(ResourceType.UNKNOWN.getName())) {
            name = name + type.getName();
        }
        if (action != null && action.trim().length() > 0) {
            name = name + (name.length() > 0 ? "." : "") + action;
        }
        if (resourceId != null && resourceId.trim().length() > 0) {
            name = name + (name.length() > 0 ? "." : "") + resourceId;
        }
        return name;
    }
}

