/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.commons.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import org.wymiwyg.commons.util.Base64;
import org.wymiwyg.commons.util.text.W3CDateFormat;

public class Util {
    private static char createRandomChar() {
        return (char)(97.0 + Math.random() * 25.0);
    }

    public static String createRandomString(int length) {
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = Util.createRandomChar();
        }
        return new String(chars);
    }

    public static String createURN5() {
        StringBuffer result = new StringBuffer("urn:urn-5:");
        result.append(Util.replaceSlashWithHyphen(new String(Base64.encode(Util.createRandomBytes(20)))));
        return result.toString();
    }

    public static String replaceSlashWithHyphen(String origin) {
        char[] resulltChars = origin.toCharArray();
        for (int i = 0; i < resulltChars.length - 1; ++i) {
            if (resulltChars[i] != '/') continue;
            resulltChars[i] = 45;
        }
        return new String(resulltChars, 0, resulltChars.length - 1);
    }

    public static byte[] createRandomBytes(int length) {
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = Util.createRandomByte();
        }
        return result;
    }

    private static byte createRandomByte() {
        return (byte)(Math.random() * 255.0);
    }

    public static String formatDate(Date date) {
        return new W3CDateFormat().format(date);
    }

    public static String sha1(String s) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("sha1 not supported by plattform");
        }
        try {
            byte[] result = md.digest(s.getBytes("UTF-8"));
            return Util.bytes2HexString(result);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("utf-8 not supported by plattform");
        }
    }

    public static String bytes2HexString(byte[] bytes) {
        StringBuffer resultBuffer = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            resultBuffer.append(Util.byte2Hex(bytes[i]));
        }
        return resultBuffer.toString();
    }

    private static String byte2Hex(byte b) {
        int i = Util.unsignedByteToInt(b);
        String hexChars = "0123456789abcdef";
        byte low = (byte)(i % 16);
        byte high = (byte)(i / 16);
        return "" + hexChars.charAt(high) + hexChars.charAt(low);
    }

    private static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }
}

