/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RefSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.java.nio.fs.jgit.util.JGitUtil;
import org.uberfire.java.nio.fs.jgit.util.commands.Clone;
import org.uberfire.java.nio.fs.jgit.util.exceptions.GitException;

public class Fork
extends Clone {
    private static final String DOT_GIT_EXT = ".git";
    private Logger logger = LoggerFactory.getLogger(Fork.class);
    private File parentFolder;
    private final String source;
    private final String target;
    private CredentialsProvider credentialsProvider;

    public Fork(File parentFolder, String source, String target, CredentialsProvider credentialsProvider) {
        this.parentFolder = (File)PortablePreconditions.checkNotNull((String)"parentFolder", (Object)parentFolder);
        this.source = PortablePreconditions.checkNotEmpty((String)"source", (String)source);
        this.target = PortablePreconditions.checkNotEmpty((String)"target", (String)target);
        this.credentialsProvider = (CredentialsProvider)PortablePreconditions.checkNotNull((String)"credentialsProvider", (Object)credentialsProvider);
    }

    public Optional<Git> execute() {
        Git gitDestination;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Forking repository <{}> to <{}>", (Object)this.source, (Object)this.target);
        }
        File origin = new File(this.parentFolder, this.source + DOT_GIT_EXT);
        File destination = new File(this.parentFolder, this.target + DOT_GIT_EXT);
        try {
            if (destination.exists()) {
                String message = String.format("Cannot fork because destination repository <%s> already exists", this.target);
                this.logger.error(message);
                throw new GitException(message);
            }
            FileUtils.copyDirectory((File)origin, (File)destination);
            gitDestination = Git.open((File)destination);
            this.setOriginToRepository(gitDestination, origin);
            JGitUtil.fetchRepository(gitDestination, this.credentialsProvider, new RefSpec[0]);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Repository <{}> forked successfuly from <{}>", (Object)this.target, (Object)this.source);
            }
        }
        catch (IOException | GitAPIException e) {
            throw new GitException("Cannot fork repository", e);
        }
        return Optional.ofNullable(gitDestination);
    }

    private void setOriginToRepository(Git gitDestination, File origin) throws IOException {
        StoredConfig config = gitDestination.getRepository().getConfig();
        config.setString("remote", "origin", "url", origin.getPath());
        config.save();
    }
}

