/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.cluster;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Named;
import org.uberfire.backend.server.cluster.ClusterServiceFactorySetup;
import org.uberfire.commons.cluster.ClusterServiceFactory;
import org.uberfire.commons.services.cdi.Startup;
import org.uberfire.commons.services.cdi.StartupType;

@ApplicationScoped
@Startup(value=StartupType.BOOTSTRAP)
public class ClusterServiceFactoryProducer {
    private final ClusterServiceFactory factory;
    private AtomicBoolean initialized = new AtomicBoolean(false);

    ClusterServiceFactoryProducer() {
        this.factory = this.buildFactory();
    }

    ClusterServiceFactory buildFactory() {
        return ClusterServiceFactorySetup.buildFactory();
    }

    @Produces
    @Named(value="clusterServiceFactory")
    public synchronized ClusterServiceFactory clusterServiceFactory() {
        if (this.factory != null && !this.initialized.getAndSet(true)) {
            this.factory.build(null);
        }
        return this.factory;
    }
}

