/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import java.util.Map;
import java.util.TreeMap;
import org.apache.helix.HelixProperty;
import org.apache.helix.ZNRecord;
import org.apache.helix.task.TaskState;

public class WorkflowContext
extends HelixProperty {
    public static final String WORKFLOW_STATE = "STATE";
    public static final String START_TIME = "START_TIME";
    public static final String FINISH_TIME = "FINISH_TIME";
    public static final String JOB_STATES = "JOB_STATES";
    public static final String LAST_SCHEDULED_WORKFLOW = "LAST_SCHEDULED_WORKFLOW";
    public static final int UNFINISHED = -1;

    public WorkflowContext(ZNRecord record) {
        super(record);
    }

    public void setWorkflowState(TaskState s) {
        if (this._record.getSimpleField(WORKFLOW_STATE) == null) {
            this._record.setSimpleField(WORKFLOW_STATE, s.name());
        } else if (!this._record.getSimpleField(WORKFLOW_STATE).equals(TaskState.FAILED.name()) && !this._record.getSimpleField(WORKFLOW_STATE).equals(TaskState.COMPLETED.name())) {
            this._record.setSimpleField(WORKFLOW_STATE, s.name());
        }
    }

    public TaskState getWorkflowState() {
        String s = this._record.getSimpleField(WORKFLOW_STATE);
        if (s == null) {
            return null;
        }
        return TaskState.valueOf(s);
    }

    public void setJobState(String jobResource, TaskState s) {
        Map<String, String> states = this._record.getMapField(JOB_STATES);
        if (states == null) {
            states = new TreeMap<String, String>();
            this._record.setMapField(JOB_STATES, states);
        }
        states.put(jobResource, s.name());
    }

    public TaskState getJobState(String jobResource) {
        Map<String, String> states = this._record.getMapField(JOB_STATES);
        if (states == null) {
            return null;
        }
        String s = states.get(jobResource);
        if (s == null) {
            return null;
        }
        return TaskState.valueOf(s);
    }

    public void setStartTime(long t) {
        this._record.setSimpleField(START_TIME, String.valueOf(t));
    }

    public long getStartTime() {
        String tStr = this._record.getSimpleField(START_TIME);
        if (tStr == null) {
            return -1L;
        }
        return Long.parseLong(tStr);
    }

    public void setFinishTime(long t) {
        this._record.setSimpleField(FINISH_TIME, String.valueOf(t));
    }

    public long getFinishTime() {
        String tStr = this._record.getSimpleField(FINISH_TIME);
        if (tStr == null) {
            return -1L;
        }
        return Long.parseLong(tStr);
    }

    public void setLastScheduledSingleWorkflow(String wf) {
        this._record.setSimpleField(LAST_SCHEDULED_WORKFLOW, wf);
    }

    public String getLastScheduledSingleWorkflow() {
        return this._record.getSimpleField(LAST_SCHEDULED_WORKFLOW);
    }
}

