/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.access.security;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Lock;
import org.apache.clerezza.rdf.core.BNode;
import org.apache.clerezza.rdf.core.LiteralFactory;
import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.Triple;
import org.apache.clerezza.rdf.core.TypedLiteral;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.access.LockableMGraph;
import org.apache.clerezza.rdf.core.access.NoSuchEntityException;
import org.apache.clerezza.rdf.core.access.TcManager;
import org.apache.clerezza.rdf.core.access.security.TcPermission;
import org.apache.clerezza.rdf.core.impl.TripleImpl;
import org.apache.clerezza.utils.security.PermissionParser;

public class TcAccessController {
    private final TcManager tcManager;
    private final UriRef permissionGraphName = new UriRef("urn:x-localinstance:/graph-access.graph");
    private String ontologyNamespace = "http://clerezza.apache.org/2010/07/10/graphpermssions#";
    private final UriRef readPermissionListProperty = new UriRef(this.ontologyNamespace + "readPermissionList");
    private final UriRef readWritePermissionListProperty = new UriRef(this.ontologyNamespace + "readWritePermissionList");
    public static final UriRef first = new UriRef("http://www.w3.org/1999/02/22-rdf-syntax-ns#first");
    public static final UriRef rest = new UriRef("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest");
    public static final UriRef rdfNil = new UriRef("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil");
    private final Map<UriRef, Collection<Permission>> readPermissionCache = Collections.synchronizedMap(new HashMap());
    private final Map<UriRef, Collection<Permission>> readWritePermissionCache = Collections.synchronizedMap(new HashMap());

    public TcAccessController(TcManager tcManager) {
        this.tcManager = tcManager;
    }

    public void checkReadPermission(UriRef tripleCollectionUri) {
        if (tripleCollectionUri.equals(this.permissionGraphName)) {
            return;
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            try {
                AccessController.checkPermission(new AllPermission());
            }
            catch (AccessControlException e) {
                Collection<Permission> perms = this.getRequiredReadPermissions(tripleCollectionUri);
                if (perms.size() > 0) {
                    for (Permission permission : perms) {
                        AccessController.checkPermission(permission);
                    }
                }
                AccessController.checkPermission(new TcPermission(tripleCollectionUri.getUnicodeString(), "read"));
            }
        }
    }

    public void checkReadWritePermission(UriRef tripleCollectionUri) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            try {
                AccessController.checkPermission(new AllPermission());
            }
            catch (AccessControlException e) {
                if (tripleCollectionUri.equals(this.permissionGraphName)) {
                    AccessController.checkPermission(new TcPermission(tripleCollectionUri.getUnicodeString(), "readwrite"));
                }
                Collection<Permission> perms = this.getRequiredReadWritePermissions(tripleCollectionUri);
                if (perms.size() > 0) {
                    for (Permission permission : perms) {
                        AccessController.checkPermission(permission);
                    }
                }
                AccessController.checkPermission(new TcPermission(tripleCollectionUri.getUnicodeString(), "readwrite"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRequiredReadPermissionStrings(UriRef tripleCollectionUri, Collection<String> permissionDescriptions) {
        this.readPermissionCache.remove(tripleCollectionUri);
        LockableMGraph permissionMGraph = this.getOrCreatePermisionGraph();
        Lock l = permissionMGraph.getLock().writeLock();
        l.lock();
        try {
            this.removeExistingRequiredReadPermissions(tripleCollectionUri, permissionMGraph);
            NonLiteral permissionList = this.createList(permissionDescriptions.iterator(), permissionMGraph);
            permissionMGraph.add(new TripleImpl(tripleCollectionUri, this.readPermissionListProperty, permissionList));
        }
        finally {
            l.unlock();
        }
    }

    public void setRequiredReadPermissions(UriRef tripleCollectionUri, Collection<Permission> permissions) {
        ArrayList<String> permissionStrings = new ArrayList<String>();
        for (Permission permission : permissions) {
            permissionStrings.add(permission.toString());
        }
        this.setRequiredReadPermissionStrings(tripleCollectionUri, permissionStrings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRequiredReadWritePermissionStrings(UriRef tripleCollectionUri, Collection<String> permissionDescriptions) {
        this.readWritePermissionCache.remove(tripleCollectionUri);
        LockableMGraph permissionMGraph = this.getOrCreatePermisionGraph();
        Lock l = permissionMGraph.getLock().writeLock();
        l.lock();
        try {
            this.removeExistingRequiredReadPermissions(tripleCollectionUri, permissionMGraph);
            NonLiteral permissionList = this.createList(permissionDescriptions.iterator(), permissionMGraph);
            permissionMGraph.add(new TripleImpl(tripleCollectionUri, this.readWritePermissionListProperty, permissionList));
        }
        finally {
            l.unlock();
        }
    }

    public void setRequiredReadWritePermissions(UriRef tripleCollectionUri, Collection<Permission> permissions) {
        ArrayList<String> permissionStrings = new ArrayList<String>();
        for (Permission permission : permissions) {
            permissionStrings.add(permission.toString());
        }
        this.setRequiredReadWritePermissionStrings(tripleCollectionUri, permissionStrings);
    }

    public Collection<Permission> getRequiredReadPermissions(UriRef tripleCollectionUri) {
        Collection<Permission> result = this.readPermissionCache.get(tripleCollectionUri);
        if (result == null) {
            result = new ArrayList<Permission>();
            Collection<String> permissionStrings = this.getRequiredReadPermissionStrings(tripleCollectionUri);
            for (String string : permissionStrings) {
                result.add(PermissionParser.getPermission((String)string, (ClassLoader)this.getClass().getClassLoader()));
            }
            this.readPermissionCache.put(tripleCollectionUri, result);
        }
        return result;
    }

    public Collection<Permission> getRequiredReadWritePermissions(UriRef tripleCollectionUri) {
        Collection<Permission> result = this.readWritePermissionCache.get(tripleCollectionUri);
        if (result == null) {
            result = new ArrayList<Permission>();
            Collection<String> permissionStrings = this.getRequiredReadWritePermissionStrings(tripleCollectionUri);
            for (String string : permissionStrings) {
                result.add(PermissionParser.getPermission((String)string, (ClassLoader)this.getClass().getClassLoader()));
            }
            this.readWritePermissionCache.put(tripleCollectionUri, result);
        }
        return result;
    }

    private NonLiteral createList(Iterator<String> iterator, LockableMGraph permissionMGraph) {
        if (!iterator.hasNext()) {
            return rdfNil;
        }
        BNode result = new BNode();
        permissionMGraph.add(new TripleImpl(result, first, LiteralFactory.getInstance().createTypedLiteral(iterator.next())));
        permissionMGraph.add(new TripleImpl(result, rest, this.createList(iterator, permissionMGraph)));
        return result;
    }

    private void removeExistingRequiredReadPermissions(UriRef tripleCollectionUri, LockableMGraph permissionMGraph) {
        try {
            Triple t = permissionMGraph.filter(tripleCollectionUri, this.readPermissionListProperty, null).next();
            Resource list = t.getObject();
            this.removeList((NonLiteral)list, permissionMGraph);
            permissionMGraph.remove(t);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    private void removeList(NonLiteral list, LockableMGraph permissionMGraph) {
        try {
            Triple t = permissionMGraph.filter(list, rest, null).next();
            Resource restList = t.getObject();
            this.removeList((NonLiteral)restList, permissionMGraph);
            permissionMGraph.remove(t);
            Iterator<Triple> iter = permissionMGraph.filter(list, first, null);
            iter.next();
            iter.remove();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    private Collection<String> getRequiredReadWritePermissionStrings(UriRef tripleCollectionUri) {
        return this.getRequiredPermissionStrings(tripleCollectionUri, this.readWritePermissionListProperty);
    }

    private Collection<String> getRequiredReadPermissionStrings(UriRef tripleCollectionUri) {
        return this.getRequiredPermissionStrings(tripleCollectionUri, this.readPermissionListProperty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<String> getRequiredPermissionStrings(UriRef tripleCollectionUri, UriRef property) {
        LinkedList<String> linkedList;
        LockableMGraph permissionMGraph = this.tcManager.getMGraph(this.permissionGraphName);
        Lock l = permissionMGraph.getLock().readLock();
        l.lock();
        try {
            Triple t = permissionMGraph.filter(tripleCollectionUri, property, null).next();
            NonLiteral list = (NonLiteral)t.getObject();
            LinkedList<String> result = new LinkedList<String>();
            this.readList(list, permissionMGraph, result);
            linkedList = result;
        }
        catch (NoSuchElementException e) {
            try {
                ArrayList<String> arrayList = new ArrayList<String>(0);
                l.unlock();
                return arrayList;
            }
            catch (Throwable throwable) {
                try {
                    l.unlock();
                    throw throwable;
                }
                catch (NoSuchEntityException e2) {
                    return new ArrayList<String>(0);
                }
            }
        }
        l.unlock();
        return linkedList;
    }

    private void readList(NonLiteral list, LockableMGraph permissionMGraph, LinkedList<String> target) {
        if (list.equals(rdfNil)) {
            return;
        }
        Triple restTriple = permissionMGraph.filter(list, rest, null).next();
        NonLiteral restList = (NonLiteral)restTriple.getObject();
        this.readList(restList, permissionMGraph, target);
        Triple firstTriple = permissionMGraph.filter(list, first, null).next();
        TypedLiteral firstValue = (TypedLiteral)firstTriple.getObject();
        String value = LiteralFactory.getInstance().createObject(String.class, firstValue);
        target.addFirst(value);
    }

    private LockableMGraph getOrCreatePermisionGraph() {
        try {
            return this.tcManager.getMGraph(this.permissionGraphName);
        }
        catch (NoSuchEntityException e) {
            return this.tcManager.createMGraph(this.permissionGraphName);
        }
    }
}

