/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.helix.task.JobDag;
import org.apache.helix.task.ScheduleConfig;
import org.apache.helix.task.TargetState;
import org.apache.helix.task.TaskUtil;

public class WorkflowConfig {
    public static final String DAG = "Dag";
    public static final String TARGET_STATE = "TargetState";
    public static final String EXPIRY = "Expiry";
    public static final String START_TIME = "StartTime";
    public static final String RECURRENCE_UNIT = "RecurrenceUnit";
    public static final String RECURRENCE_INTERVAL = "RecurrenceInterval";
    public static final String TERMINABLE = "Terminable";
    public static final long DEFAULT_EXPIRY = 86400000L;
    public static final SimpleDateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss");
    private final JobDag _jobDag;
    private final TargetState _targetState;
    private final long _expiry;
    private final boolean _terminable;
    private final ScheduleConfig _scheduleConfig;

    protected WorkflowConfig(JobDag jobDag, TargetState targetState, long expiry, boolean terminable, ScheduleConfig scheduleConfig) {
        this._jobDag = jobDag;
        this._targetState = targetState;
        this._expiry = expiry;
        this._terminable = terminable;
        this._scheduleConfig = scheduleConfig;
    }

    public JobDag getJobDag() {
        return this._jobDag;
    }

    public TargetState getTargetState() {
        return this._targetState;
    }

    public long getExpiry() {
        return this._expiry;
    }

    public boolean isTerminable() {
        return this._terminable;
    }

    public ScheduleConfig getScheduleConfig() {
        return this._scheduleConfig;
    }

    public Map<String, String> getResourceConfigMap() throws Exception {
        HashMap<String, String> cfgMap = new HashMap<String, String>();
        cfgMap.put(DAG, this.getJobDag().toJson());
        cfgMap.put(EXPIRY, String.valueOf(this.getExpiry()));
        cfgMap.put(TARGET_STATE, this.getTargetState().name());
        cfgMap.put(TERMINABLE, String.valueOf(this.isTerminable()));
        ScheduleConfig scheduleConfig = this.getScheduleConfig();
        if (scheduleConfig != null) {
            Date startTime = scheduleConfig.getStartTime();
            if (startTime != null) {
                String formattedTime = DEFAULT_DATE_FORMAT.format(startTime);
                cfgMap.put(START_TIME, formattedTime);
            }
            if (scheduleConfig.isRecurring()) {
                cfgMap.put(RECURRENCE_UNIT, scheduleConfig.getRecurrenceUnit().toString());
                cfgMap.put(RECURRENCE_INTERVAL, scheduleConfig.getRecurrenceInterval().toString());
            }
        }
        return cfgMap;
    }

    static {
        DEFAULT_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public static class Builder {
        private JobDag _taskDag = JobDag.EMPTY_DAG;
        private TargetState _targetState = TargetState.START;
        private long _expiry = 86400000L;
        private boolean _isTerminable = true;
        private ScheduleConfig _scheduleConfig;

        public WorkflowConfig build() {
            this.validate();
            return new WorkflowConfig(this._taskDag, this._targetState, this._expiry, this._isTerminable, this._scheduleConfig);
        }

        public Builder setJobDag(JobDag v) {
            this._taskDag = v;
            return this;
        }

        public Builder setExpiry(long v) {
            this._expiry = v;
            return this;
        }

        public Builder setTerminable(boolean isTerminable) {
            this._isTerminable = isTerminable;
            return this;
        }

        public Builder setTargetState(TargetState v) {
            this._targetState = v;
            return this;
        }

        public Builder setScheduleConfig(ScheduleConfig scheduleConfig) {
            this._scheduleConfig = scheduleConfig;
            return this;
        }

        public static Builder fromMap(Map<String, String> cfg) {
            ScheduleConfig scheduleConfig;
            Builder b = new Builder();
            if (cfg.containsKey(WorkflowConfig.EXPIRY)) {
                b.setExpiry(Long.parseLong(cfg.get(WorkflowConfig.EXPIRY)));
            }
            if (cfg.containsKey(WorkflowConfig.DAG)) {
                b.setJobDag(JobDag.fromJson(cfg.get(WorkflowConfig.DAG)));
            }
            if (cfg.containsKey(WorkflowConfig.TARGET_STATE)) {
                b.setTargetState(TargetState.valueOf(cfg.get(WorkflowConfig.TARGET_STATE)));
            }
            if (cfg.containsKey(WorkflowConfig.TERMINABLE)) {
                b.setTerminable(Boolean.parseBoolean(cfg.get(WorkflowConfig.TERMINABLE)));
            }
            if ((scheduleConfig = TaskUtil.parseScheduleFromConfigMap(cfg)) != null) {
                b.setScheduleConfig(scheduleConfig);
            }
            return b;
        }

        private void validate() {
            if (this._expiry < 0L) {
                throw new IllegalArgumentException(String.format("%s has invalid value %s", WorkflowConfig.EXPIRY, this._expiry));
            }
            if (this._scheduleConfig != null && !this._scheduleConfig.isValid()) {
                throw new IllegalArgumentException("Scheduler configuration is invalid. The configuration must have a start time if it is one-time, and it must have a positive interval magnitude if it is recurring");
            }
        }
    }
}

