/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.plugins.processors;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.plugin.PluginProcessor;
import org.uberfire.backend.plugin.RuntimePlugin;
import org.uberfire.backend.plugin.RuntimePluginProcessor;
import org.uberfire.workbench.events.PluginAddedEvent;
import org.uberfire.workbench.events.PluginUpdatedEvent;

public abstract class AbstractRuntimePluginProcessor
implements RuntimePluginProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRuntimePluginProcessor.class);
    final Map<String, RuntimePlugin> availableRuntimePlugins = new HashMap<String, RuntimePlugin>();
    private Event<PluginAddedEvent> pluginAddedEvent;
    private Event<PluginUpdatedEvent> pluginUpdatedEvent;

    public AbstractRuntimePluginProcessor() {
    }

    public AbstractRuntimePluginProcessor(Event<PluginAddedEvent> pluginAddedEvent, Event<PluginUpdatedEvent> pluginUpdatedEvent) {
        this.pluginAddedEvent = pluginAddedEvent;
        this.pluginUpdatedEvent = pluginUpdatedEvent;
    }

    public Collection<RuntimePlugin> getAvailableRuntimePlugins() {
        return this.availableRuntimePlugins.values();
    }

    public void removeAll() {
        this.availableRuntimePlugins.clear();
    }

    public boolean isRegistered(String pluginName) {
        return this.availableRuntimePlugins.containsKey(pluginName);
    }

    public boolean shouldProcess(String pluginName) {
        return pluginName.endsWith(this.getType().getExtension());
    }

    public void process(String pluginName, String pluginDeploymentDir, boolean notifyClients) {
        if (!this.isRegistered(pluginName)) {
            this.loadPlugin(pluginName, pluginDeploymentDir);
            if (notifyClients) {
                this.pluginAddedEvent.fire((Object)new PluginAddedEvent(pluginName));
            }
        } else if (notifyClients) {
            this.pluginUpdatedEvent.fire((Object)new PluginUpdatedEvent(pluginName));
        }
    }

    private void loadPlugin(String pluginName, String pluginDeploymentDir) {
        try {
            String pluginContent = this.getPluginContent(pluginName, pluginDeploymentDir);
            this.availableRuntimePlugins.put(pluginName, new RuntimePlugin(this.getType(), pluginName, pluginContent));
        }
        catch (IOException e) {
            LOG.error("Failed to initialize " + pluginDeploymentDir, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    String getPluginContent(String pluginName, String pluginDeploymentDir) throws IOException {
        Path path = Paths.get(pluginDeploymentDir + File.separator + pluginName, new String[0]);
        return new String(Files.readAllBytes(path));
    }

    abstract PluginProcessor.PluginProcessorType getType();
}

