/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.EnabledByProperty;
import org.jboss.errai.ioc.client.api.EntryPoint;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.ActivityMetaInfo;
import org.uberfire.client.mvp.IsSplashScreen;
import org.uberfire.client.mvp.SplashScreenActivity;
import org.uberfire.client.workbench.events.NewPerspectiveEvent;
import org.uberfire.client.workbench.events.NewWorkbenchScreenEvent;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.commons.data.Pair;

@EntryPoint
@EnabledByProperty(value="uberfire.plugin.mode.active", negated=true)
public class ActivityBeansCache {
    private final Map<String, SyncBeanDef<Activity>> activitiesById = new HashMap<String, SyncBeanDef<Activity>>();
    private final List<ActivityAndMetaInfo> resourceActivities = new ArrayList<ActivityAndMetaInfo>();
    private final List<SplashScreenActivity> splashActivities = new ArrayList<SplashScreenActivity>();
    @Inject
    private SyncBeanManager iocManager;
    @Inject
    private Event<NewPerspectiveEvent> newPerspectiveEventEvent;
    @Inject
    private Event<NewWorkbenchScreenEvent> newWorkbenchScreenEventEvent;

    @PostConstruct
    void init() {
        Collection<SyncBeanDef<Activity>> availableActivities = this.getAvailableActivities();
        for (SyncBeanDef<Activity> activityBean : availableActivities) {
            String id = activityBean.getName();
            this.validateUniqueness(id);
            this.activitiesById.put(id, activityBean);
            if (this.isSplashScreen(activityBean.getQualifiers())) {
                this.splashActivities.add((SplashScreenActivity)activityBean.getInstance());
                continue;
            }
            Pair<Integer, List<String>> metaInfo = this.generateActivityMetaInfo(activityBean);
            if (metaInfo == null) continue;
            this.getResourceActivities().add(new ActivityAndMetaInfo(activityBean, (Integer)metaInfo.getK1(), (List)metaInfo.getK2()));
        }
        this.sortResourceActivitiesByPriority();
    }

    List<ActivityAndMetaInfo> getResourceActivities() {
        return this.resourceActivities;
    }

    void sortResourceActivitiesByPriority() {
        Collections.sort(this.getResourceActivities(), new Comparator<ActivityAndMetaInfo>(){

            @Override
            public int compare(ActivityAndMetaInfo o1, ActivityAndMetaInfo o2) {
                if (o1.getPriority() < o2.getPriority()) {
                    return 1;
                }
                if (o1.getPriority() > o2.getPriority()) {
                    return -1;
                }
                return 0;
            }
        });
    }

    Collection<SyncBeanDef<Activity>> getAvailableActivities() {
        ArrayList<SyncBeanDef<Activity>> activeBeans = new ArrayList<SyncBeanDef<Activity>>();
        for (SyncBeanDef bean : this.iocManager.lookupBeans(Activity.class)) {
            if (!bean.isActivated()) continue;
            activeBeans.add((SyncBeanDef<Activity>)bean);
        }
        return activeBeans;
    }

    private boolean isSplashScreen(Set<Annotation> qualifiers) {
        for (Annotation qualifier : qualifiers) {
            if (!(qualifier instanceof IsSplashScreen)) continue;
            return true;
        }
        return false;
    }

    public void removeActivity(String id) {
        this.activitiesById.remove(id);
    }

    public void addNewScreenActivity(SyncBeanDef<Activity> activityBean) {
        String id = activityBean.getName();
        this.validateUniqueness(id);
        this.activitiesById.put(id, activityBean);
        this.newWorkbenchScreenEventEvent.fire((Object)new NewWorkbenchScreenEvent(id));
    }

    private void validateUniqueness(String id) {
        if (this.activitiesById.keySet().contains(id)) {
            throw new RuntimeException("Conflict detected: Activity already exists with id " + id);
        }
    }

    public void addNewPerspectiveActivity(SyncBeanDef<Activity> activityBean) {
        String id = activityBean.getName();
        this.validateUniqueness(id);
        this.activitiesById.put(id, activityBean);
        this.newPerspectiveEventEvent.fire((Object)new NewPerspectiveEvent(id));
    }

    public void addNewEditorActivity(SyncBeanDef<Activity> activityBean, String priority, String resourceTypeName) {
        String id = activityBean.getName();
        this.validateUniqueness(id);
        this.activitiesById.put(id, activityBean);
        this.resourceActivities.add(new ActivityAndMetaInfo(activityBean, Integer.valueOf(priority), Arrays.asList(resourceTypeName)));
        this.sortResourceActivitiesByPriority();
    }

    public void addNewSplashScreenActivity(SyncBeanDef<Activity> activityBean) {
        String id = activityBean.getName();
        this.validateUniqueness(id);
        this.activitiesById.put(id, activityBean);
        this.splashActivities.add((SplashScreenActivity)activityBean.getInstance());
    }

    public boolean hasActivity(String id) {
        return this.activitiesById.containsKey(id);
    }

    public List<SplashScreenActivity> getSplashScreens() {
        return this.splashActivities;
    }

    public SyncBeanDef<Activity> getActivity(String id) {
        return this.activitiesById.get(id);
    }

    public SyncBeanDef<Activity> getActivity(Path path) {
        for (ActivityAndMetaInfo currentActivity : this.getResourceActivities()) {
            for (ClientResourceType resourceType : currentActivity.getResourceTypes()) {
                if (!resourceType.accept(path)) continue;
                return currentActivity.getActivityBean();
            }
        }
        throw new EditorResourceTypeNotFound();
    }

    Pair<Integer, List<String>> generateActivityMetaInfo(SyncBeanDef<Activity> activityBean) {
        return ActivityMetaInfo.generate(activityBean);
    }

    public List<String> getActivitiesById() {
        return new ArrayList<String>(this.activitiesById.keySet());
    }

    private class EditorResourceTypeNotFound
    extends RuntimeException {
        private EditorResourceTypeNotFound() {
        }
    }

    class ActivityAndMetaInfo {
        private final SyncBeanDef<Activity> activityBean;
        private final int priority;
        final List<String> resourceTypesNames;
        ClientResourceType[] resourceTypes;

        ActivityAndMetaInfo(SyncBeanDef<Activity> activityBean, int priority, List<String> resourceTypesNames) {
            this.activityBean = activityBean;
            this.priority = priority;
            this.resourceTypesNames = resourceTypesNames;
        }

        public SyncBeanDef<Activity> getActivityBean() {
            return this.activityBean;
        }

        public int getPriority() {
            return this.priority;
        }

        public ClientResourceType[] getResourceTypes() {
            if (this.resourceTypes == null) {
                this.dynamicLookupResourceTypes();
            }
            return this.resourceTypes;
        }

        private void dynamicLookupResourceTypes() {
            this.resourceTypes = new ClientResourceType[this.resourceTypesNames.size()];
            for (int i = 0; i < this.resourceTypesNames.size(); ++i) {
                String resourceTypeIdentifier = this.resourceTypesNames.get(i);
                Collection resourceTypeBeans = ActivityBeansCache.this.iocManager.lookupBeans(resourceTypeIdentifier);
                if (resourceTypeBeans.isEmpty()) {
                    throw new RuntimeException("ClientResourceType " + resourceTypeIdentifier + " not found");
                }
                this.resourceTypes[i] = (ClientResourceType)((SyncBeanDef)resourceTypeBeans.iterator().next()).getInstance();
            }
        }
    }
}

