/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.processors;

import org.jboss.errai.codegen.Statement;
import org.jboss.errai.codegen.meta.MetaMethod;
import org.jboss.errai.codegen.util.Stmt;
import org.jboss.errai.ioc.client.api.CodeDecorator;
import org.jboss.errai.ioc.rebind.ioc.extension.IOCDecoratorExtension;
import org.jboss.errai.ioc.rebind.ioc.injector.api.Decorable;
import org.jboss.errai.ioc.rebind.ioc.injector.api.FactoryController;
import org.uberfire.security.annotations.PermissionCheck;
import org.uberfire.security.client.authz.AuthorizationManagerHelper;
import org.uberfire.security.processors.ResourceCheckProcessor;

@CodeDecorator
public class PermissionCheckProcessor
extends IOCDecoratorExtension<PermissionCheck> {
    public PermissionCheckProcessor(Class<PermissionCheck> decoratesWith) {
        super(decoratesWith);
    }

    public void generateDecorator(Decorable decorable, FactoryController controller) {
        MetaMethod metaMethod = decorable.getAsMethod();
        PermissionCheck securedResource = (PermissionCheck)metaMethod.getAnnotation(PermissionCheck.class);
        String permission = securedResource.value();
        String onGranted = securedResource.onGranted();
        String onDenied = securedResource.onDenied();
        String declaringClass = metaMethod.getDeclaringClassName();
        if (!metaMethod.getReturnType().getName().equals("void")) {
            throw new RuntimeException("The @PermissionCheck annotated method \"" + declaringClass + "#" + metaMethod.getName() + "\" must return void");
        }
        if (permission == null || permission.trim().length() == 0) {
            Statement stmt = this.createPermissionCheck(permission, onGranted, onDenied);
            controller.addInvokeBefore(metaMethod, stmt);
        }
    }

    public Statement createPermissionCheck(String permission, String onGranted, String onDenied) {
        return ResourceCheckProcessor.buildCheckStatement(Stmt.invokeStatic(AuthorizationManagerHelper.class, (String)"authorize", (Object[])new Object[]{permission}), onGranted, onDenied);
    }
}

