/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.commons.util.arguments;

import java.util.ArrayList;
import java.util.List;
import org.wymiwyg.commons.util.arguments.ArgumentProcessor;
import org.wymiwyg.commons.util.arguments.InvalidArgumentsException;
import org.wymiwyg.commons.util.arguments.PushBackIteratorImpl;
import org.wymiwyg.commons.util.arguments.SingleNamedAttributeProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedAttributeProcessor
implements ArgumentProcessor {
    List<SingleNamedAttributeProcessor> singleNamedAttributeProcessors = new ArrayList<SingleNamedAttributeProcessor>();
    List<SingleNamedAttributeProcessor> longSingleNamedAttributeProcessors = new ArrayList<SingleNamedAttributeProcessor>();

    public void addNamedAttributeProcessor(SingleNamedAttributeProcessor processor) {
        this.singleNamedAttributeProcessors.add(processor);
    }

    public void addLongNameAttributeProcessor(SingleNamedAttributeProcessor processor) {
        this.longSingleNamedAttributeProcessors.add(processor);
    }

    @Override
    public void process(List<String> argumentList) throws InvalidArgumentsException {
        ArrayList<String> remaining = new ArrayList<String>();
        PushBackIteratorImpl iter = new PushBackIteratorImpl(argumentList.iterator());
        while (iter.hasNext()) {
            String current = (String)iter.next();
            if (current.startsWith("-")) {
                boolean processed;
                String attributeName;
                if (current.startsWith("--")) {
                    attributeName = current.substring(2);
                    processed = false;
                    for (SingleNamedAttributeProcessor processor : this.longSingleNamedAttributeProcessors) {
                        if (!processor.handles(attributeName)) continue;
                        processor.process(iter);
                        processed = true;
                    }
                    if (processed) continue;
                    remaining.add(current);
                    continue;
                }
                attributeName = current.substring(1);
                processed = false;
                for (SingleNamedAttributeProcessor processor : this.singleNamedAttributeProcessors) {
                    if (!processor.handles(attributeName)) continue;
                    processor.process(iter);
                    processed = true;
                }
                if (processed) continue;
                remaining.add(current);
                continue;
            }
            remaining.add(current);
        }
        argumentList.clear();
        argumentList.addAll(remaining);
    }
}

