/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.commons.util.dirbrowser;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.JarURLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wymiwyg.commons.util.dirbrowser.PathNameFilter;
import org.wymiwyg.commons.util.dirbrowser.PathNode;

public class ZipPathNode
implements PathNode {
    private static Log logger = LogFactory.getLog(ZipPathNode.class);
    private String entryName;
    private ZipFile file;
    private static Map listCache = Collections.synchronizedMap(new HashMap());

    public ZipPathNode(JarURLConnection connection) throws IOException {
        this.entryName = connection.getJarEntry().getName();
        this.file = connection.getJarFile();
    }

    public ZipPathNode(ZipFile file, String entryName) {
        this.file = file;
        this.entryName = entryName;
    }

    public PathNode getSubPath(String requestPath) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.entryName);
        if (!(this.entryName.equals("") || this.entryName.endsWith("/") || requestPath.startsWith("/"))) {
            buffer.append('/');
        }
        buffer.append(requestPath);
        return new ZipPathNode(this.file, buffer.toString());
    }

    public boolean isDirectory() {
        ZipEntry entry = this.file.getEntry(this.entryName);
        if (entry != null && entry.isDirectory()) {
            return true;
        }
        entry = this.file.getEntry(this.entryName + "/");
        return entry != null && entry.isDirectory();
    }

    public String[] list(PathNameFilter filter) {
        String[] fullList = this.list();
        ArrayList<String> resultList = new ArrayList<String>();
        for (int i = 0; i < fullList.length; ++i) {
            if (!filter.accept(this, fullList[i])) continue;
            resultList.add(fullList[i]);
        }
        return resultList.toArray(new String[resultList.size()]);
    }

    public String[] list() {
        String[] values;
        Reference currentRef = (Reference)listCache.get(this);
        if (currentRef != null && (values = (String[])currentRef.get()) != null) {
            return values;
        }
        Enumeration<? extends ZipEntry> jarEntries = this.file.entries();
        String name = this.entryName;
        if (!name.equals("") && name.charAt(name.length() - 1) != '/') {
            name = name + "/";
        }
        HashSet<String> resultList = new HashSet<String>();
        while (jarEntries.hasMoreElements()) {
            String subPath;
            ZipEntry current = jarEntries.nextElement();
            String currentName = current.getName();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("evaluating: " + current));
            }
            if (currentName.length() <= name.length() || !currentName.startsWith(name) || (subPath = currentName.substring(name.length())).length() <= 0) continue;
            int slashPos = subPath.indexOf(47);
            if (slashPos == -1) {
                resultList.add(subPath);
                continue;
            }
            resultList.add(subPath.substring(0, slashPos + 1));
        }
        String[] result = resultList.toArray(new String[resultList.size()]);
        listCache.put(this, new WeakReference<String[]>(result));
        return result;
    }

    public InputStream getInputStream() throws IOException {
        return this.file.getInputStream(this.file.getEntry(this.entryName));
    }

    public String toString() {
        return "ZipPathNode for entry " + this.entryName + " in file " + this.file.getName();
    }

    public long getLength() {
        return this.file.getEntry(this.entryName).getSize();
    }

    public boolean equals(Object other) {
        return other.getClass().equals(this.getClass()) && ((ZipPathNode)other).file.equals(this.file) && ((ZipPathNode)other).entryName.equals(this.entryName);
    }

    public int hashCode() {
        return this.file.hashCode() | this.entryName.hashCode();
    }

    public String getPath() {
        return this.entryName;
    }

    public Date getLastModified() {
        try {
            long time = this.file.getEntry(this.entryName).getTime();
            if (time > -1L) {
                return new Date(time);
            }
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public boolean exists() {
        ZipEntry entry = this.file.getEntry(this.entryName);
        return entry != null;
    }
}

