/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.annotations.processors;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import org.uberfire.annotations.processors.AbstractGenerator;
import org.uberfire.annotations.processors.GeneratorUtils;
import org.uberfire.annotations.processors.exceptions.GenerationException;
import org.uberfire.annotations.processors.facades.ClientAPIModule;

public class ContextActivityGenerator
extends AbstractGenerator {
    @Override
    public StringBuffer generate(String packageName, PackageElement packageElement, String className, Element element, ProcessingEnvironment processingEnvironment) throws GenerationException {
        String msg;
        Messager messager = processingEnvironment.getMessager();
        messager.printMessage(Diagnostic.Kind.NOTE, "Starting code generation for [" + className + "]");
        Elements elementUtils = processingEnvironment.getElementUtils();
        TypeElement classElement = (TypeElement)element;
        String identifier = ClientAPIModule.getWbContextIdentifierValueOnClass(classElement);
        String onOpenMethodName = GeneratorUtils.getOnOpenMethodName(classElement, processingEnvironment);
        String getOnContextAttachPanelDefinitionMethodName = GeneratorUtils.getOnContextAttachPanelDefinitionMethodName(classElement, processingEnvironment);
        String getTitleMethodName = GeneratorUtils.getTitleMethodName(classElement, processingEnvironment);
        ExecutableElement getTitleWidgetMethod = GeneratorUtils.getTitleWidgetMethodName(classElement, processingEnvironment);
        String getTitleWidgetMethodName = getTitleWidgetMethod == null ? null : getTitleWidgetMethod.getSimpleName().toString();
        ExecutableElement getWidgetMethod = GeneratorUtils.getWidgetMethodName(classElement, processingEnvironment);
        String getWidgetMethodName = getWidgetMethod == null ? null : getWidgetMethod.getSimpleName().toString();
        boolean hasUberView = GeneratorUtils.hasUberViewReference(classElement, processingEnvironment, getWidgetMethod);
        boolean isWidget = GeneratorUtils.getIsWidget(classElement, processingEnvironment);
        if (GeneratorUtils.debugLoggingEnabled()) {
            messager.printMessage(Diagnostic.Kind.NOTE, "Package name: " + packageName);
            messager.printMessage(Diagnostic.Kind.NOTE, "Class name: " + className);
            messager.printMessage(Diagnostic.Kind.NOTE, "Identifier: " + identifier);
            messager.printMessage(Diagnostic.Kind.NOTE, "onOpenMethodName: " + onOpenMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "getOnContextAttachPanelDefinitionMethodName: " + getOnContextAttachPanelDefinitionMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "getTitleMethodName: " + getTitleMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "getTitleWidgetMethodName: " + getTitleWidgetMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "getWidgetMethodName: " + getWidgetMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "isWidget: " + Boolean.toString(isWidget));
            messager.printMessage(Diagnostic.Kind.NOTE, "hasUberView: " + Boolean.toString(hasUberView));
        }
        if (!isWidget && getWidgetMethodName == null) {
            msg = "The WorkbenchContext must either extend IsWidget or provide a @WorkbenchPartView annotated method to return a com.google.gwt.user.client.ui.IsWidget.";
            messager.printMessage(Diagnostic.Kind.ERROR, "The WorkbenchContext must either extend IsWidget or provide a @WorkbenchPartView annotated method to return a com.google.gwt.user.client.ui.IsWidget.", classElement);
        }
        if (isWidget && getWidgetMethodName != null) {
            msg = "The WorkbenchContext both extends com.google.gwt.user.client.ui.IsWidget and provides a @WorkbenchPartView annotated method. The annotated method will take precedence.";
            messager.printMessage(Diagnostic.Kind.WARNING, "The WorkbenchContext both extends com.google.gwt.user.client.ui.IsWidget and provides a @WorkbenchPartView annotated method. The annotated method will take precedence.", classElement);
        }
        if (getTitleMethodName == null) {
            msg = "The WorkbenchContext must provide a @WorkbenchPartTitle annotated method to return a java.lang.String.";
            messager.printMessage(Diagnostic.Kind.ERROR, "The WorkbenchContext must provide a @WorkbenchPartTitle annotated method to return a java.lang.String.", classElement);
        }
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("packageName", packageName);
        root.put("className", className);
        root.put("identifier", identifier);
        root.put("realClassName", classElement.getSimpleName().toString());
        root.put("onOpenMethodName", onOpenMethodName);
        root.put("getOnContextAttachPanelDefinitionMethodName", getOnContextAttachPanelDefinitionMethodName);
        root.put("getTitleMethodName", getTitleMethodName);
        root.put("getTitleWidgetMethodName", getTitleWidgetMethodName);
        root.put("getWidgetMethodName", getWidgetMethodName);
        root.put("isWidget", isWidget);
        root.put("hasUberView", hasUberView);
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        try {
            Template template = config.getTemplate("activityContext.ftl");
            template.process(root, (Writer)bw);
        }
        catch (IOException ioe) {
            throw new GenerationException(ioe);
        }
        catch (TemplateException te) {
            throw new GenerationException(te);
        }
        finally {
            try {
                bw.close();
                sw.close();
            }
            catch (IOException ioe) {
                throw new GenerationException(ioe);
            }
        }
        messager.printMessage(Diagnostic.Kind.NOTE, "Successfully generated code for [" + className + "]");
        return sw.getBuffer();
    }
}

