/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.daemon.ssh;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.sshd.SshServer;
import org.apache.sshd.common.KeyPairProvider;
import org.apache.sshd.common.util.SecurityUtils;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.PasswordAuthenticator;
import org.apache.sshd.server.command.UnknownCommand;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.session.ServerSession;
import org.eclipse.jgit.transport.resolver.ReceivePackFactory;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProvider;
import org.uberfire.java.nio.fs.jgit.daemon.ssh.BaseGitCommand;
import org.uberfire.java.nio.fs.jgit.daemon.ssh.GitReceiveCommand;
import org.uberfire.java.nio.fs.jgit.daemon.ssh.GitUploadCommand;
import org.uberfire.java.nio.security.FileSystemAuthenticator;
import org.uberfire.java.nio.security.FileSystemAuthorizer;
import org.uberfire.java.nio.security.FileSystemUser;

public class GitSSHService {
    private final SshServer sshd = SshServer.setUpDefaultServer();
    private FileSystemAuthenticator fileSystemAuthenticator;
    private FileSystemAuthorizer fileSystemAuthorizer;
    private ExecutorService executorService;

    public void setup(File certDir, InetSocketAddress inetSocketAddress, String sshIdleTimeout, String algorithm, final ReceivePackFactory receivePackFactory, final JGitFileSystemProvider.RepositoryResolverImpl<BaseGitCommand> repositoryResolver, final ExecutorService executorService) {
        PortablePreconditions.checkNotNull((String)"certDir", (Object)certDir);
        PortablePreconditions.checkNotEmpty((String)"sshIdleTimeout", (String)sshIdleTimeout);
        PortablePreconditions.checkNotEmpty((String)"algorithm", (String)algorithm);
        PortablePreconditions.checkNotNull((String)"receivePackFactory", (Object)receivePackFactory);
        PortablePreconditions.checkNotNull((String)"repositoryResolver", repositoryResolver);
        PortablePreconditions.checkNotNull((String)"executorService", (Object)executorService);
        this.executorService = executorService;
        this.sshd.getProperties().put("idle-timeout", sshIdleTimeout);
        if (inetSocketAddress != null) {
            this.sshd.setHost(inetSocketAddress.getHostName());
            this.sshd.setPort(inetSocketAddress.getPort());
        }
        if (!certDir.exists()) {
            certDir.mkdirs();
        }
        SimpleGeneratorHostKeyProvider keyPairProvider = new SimpleGeneratorHostKeyProvider(new File(certDir, "hostkey.ser").getAbsolutePath());
        try {
            SecurityUtils.getKeyPairGenerator((String)algorithm);
            keyPairProvider.setAlgorithm(algorithm);
        }
        catch (Exception ignore) {
            throw new RuntimeException(String.format("Can't use '%s' algorithm for ssh key pair generator.", algorithm), ignore);
        }
        this.sshd.setKeyPairProvider((KeyPairProvider)keyPairProvider);
        this.sshd.setCommandFactory(new CommandFactory(){

            public Command createCommand(String command) {
                if (command.startsWith("git-upload-pack")) {
                    return new GitUploadCommand(command, repositoryResolver, GitSSHService.this.getAuthorizationManager(), executorService);
                }
                if (command.startsWith("git-receive-pack")) {
                    return new GitReceiveCommand(command, repositoryResolver, GitSSHService.this.getAuthorizationManager(), (ReceivePackFactory<BaseGitCommand>)receivePackFactory, executorService);
                }
                return new UnknownCommand(command);
            }
        });
        this.sshd.setPasswordAuthenticator(new PasswordAuthenticator(){

            public boolean authenticate(String username, String password, ServerSession session) {
                FileSystemUser user = GitSSHService.this.getUserPassAuthenticator().authenticate(username, password);
                if (user == null) {
                    return false;
                }
                session.setAttribute(BaseGitCommand.SUBJECT_KEY, (Object)user);
                return true;
            }
        });
    }

    public void stop() {
        try {
            this.sshd.stop(true);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void start() {
        try {
            this.sshd.start();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't start SSH daemon at " + this.sshd.getHost() + ":" + this.sshd.getPort(), e);
        }
    }

    public boolean isRunning() {
        return !this.sshd.isClosed() && !this.sshd.isClosing();
    }

    SshServer getSshServer() {
        return this.sshd;
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.sshd.getProperties());
    }

    public FileSystemAuthenticator getUserPassAuthenticator() {
        return this.fileSystemAuthenticator;
    }

    public void setUserPassAuthenticator(FileSystemAuthenticator fileSystemAuthenticator) {
        this.fileSystemAuthenticator = fileSystemAuthenticator;
    }

    public FileSystemAuthorizer getAuthorizationManager() {
        return this.fileSystemAuthorizer;
    }

    public void setAuthorizationManager(FileSystemAuthorizer fileSystemAuthorizer) {
        this.fileSystemAuthorizer = fileSystemAuthorizer;
    }
}

