/*
 * Decompiled with CFR 0.152.
 */
package org.lesscss;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.lesscss.Resource;

public class FileResource
implements Resource {
    private File file;

    public FileResource(File file) {
        if (file == null) {
            throw new IllegalArgumentException("File must not be null!");
        }
        this.file = file;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public long lastModified() {
        return this.file.lastModified();
    }

    public Resource createRelative(String relativePath) {
        File relativeFile = new File(this.file.getParentFile(), relativePath);
        return new FileResource(relativeFile);
    }

    public String toString() {
        return this.file.getAbsolutePath();
    }

    public String getName() {
        return this.file.getAbsolutePath();
    }
}

