/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.sparql.query.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.clerezza.rdf.core.sparql.query.Expression;
import org.apache.clerezza.rdf.core.sparql.query.GraphPattern;
import org.apache.clerezza.rdf.core.sparql.query.GroupGraphPattern;
import org.apache.clerezza.rdf.core.sparql.query.TriplePattern;
import org.apache.clerezza.rdf.core.sparql.query.impl.SimpleBasicGraphPattern;
import org.apache.clerezza.rdf.core.sparql.query.impl.SimpleOptionalGraphPattern;

public class SimpleGroupGraphPattern
implements GroupGraphPattern {
    private List<Expression> constraints = new ArrayList<Expression>();
    private List<GraphPattern> graphPatterns = new ArrayList<GraphPattern>();

    @Override
    public Set<GraphPattern> getGraphPatterns() {
        return new HashSet<GraphPattern>(this.graphPatterns);
    }

    @Override
    public List<Expression> getFilter() {
        return this.constraints;
    }

    public void addGraphPattern(GraphPattern graphPattern) {
        this.graphPatterns.add(graphPattern);
    }

    public void addConstraint(Expression constraint) {
        this.constraints.add(constraint);
    }

    public void addTriplePatterns(Set<TriplePattern> triplePatterns) {
        GraphPattern prevGraphPattern;
        int size = this.graphPatterns.size();
        if (size > 0 && (prevGraphPattern = this.graphPatterns.get(size - 1)) instanceof SimpleBasicGraphPattern) {
            ((SimpleBasicGraphPattern)prevGraphPattern).addTriplePatterns(triplePatterns);
            return;
        }
        this.graphPatterns.add(new SimpleBasicGraphPattern(triplePatterns));
    }

    public void addOptionalGraphPattern(GroupGraphPattern optional) {
        GraphPattern prevGraphPattern = null;
        int size = this.graphPatterns.size();
        if (size > 0) {
            prevGraphPattern = this.graphPatterns.remove(size - 1);
        }
        this.graphPatterns.add(new SimpleOptionalGraphPattern(prevGraphPattern, optional));
    }
}

