/*
 * Decompiled with CFR 0.152.
 */
package freemarker.cache;

import freemarker.cache.TemplateLoader;
import freemarker.cache.TemplateLoaderUtils;
import freemarker.template.utility.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ByteArrayTemplateLoader
implements TemplateLoader {
    private final Map<String, ByteArrayTemplateSource> templates = new HashMap<String, ByteArrayTemplateSource>();

    public void putTemplate(String name, byte[] templateSource) {
        this.putTemplate(name, templateSource, System.currentTimeMillis());
    }

    public void putTemplate(String name, byte[] templateSource, long lastModified) {
        this.templates.put(name, new ByteArrayTemplateSource(name, templateSource, lastModified));
    }

    public void closeTemplateSource(Object templateSource) {
    }

    public Object findTemplateSource(String name) {
        return this.templates.get(name);
    }

    public long getLastModified(Object templateSource) {
        return ((ByteArrayTemplateSource)templateSource).lastModified;
    }

    public Reader getReader(Object templateSource, String encoding) throws UnsupportedEncodingException {
        return new InputStreamReader((InputStream)new ByteArrayInputStream(((ByteArrayTemplateSource)templateSource).source), encoding);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TemplateLoaderUtils.getClassNameForToString(this));
        sb.append("(Map { ");
        int cnt = 0;
        Iterator<String> it = this.templates.keySet().iterator();
        while (it.hasNext()) {
            if (++cnt != 1) {
                sb.append(", ");
            }
            if (cnt > 10) {
                sb.append("...");
                break;
            }
            sb.append(StringUtil.jQuote((Object)it.next()));
            sb.append("=...");
        }
        if (cnt != 0) {
            sb.append(' ');
        }
        sb.append("})");
        return sb.toString();
    }

    private static class ByteArrayTemplateSource {
        private final String name;
        private final byte[] source;
        private final long lastModified;

        ByteArrayTemplateSource(String name, byte[] source, long lastModified) {
            if (name == null) {
                throw new IllegalArgumentException("name == null");
            }
            if (source == null) {
                throw new IllegalArgumentException("source == null");
            }
            if (lastModified < -1L) {
                throw new IllegalArgumentException("lastModified < -1L");
            }
            this.name = name;
            this.source = source;
            this.lastModified = lastModified;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ByteArrayTemplateSource) {
                return this.name.equals(((ByteArrayTemplateSource)obj).name);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

