/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.daemon.filters;

import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.RefFilter;

public class HiddenBranchRefFilter
implements RefFilter {
    private static final String HIDDEN_BRANCH_REGEXP = "PR-\\d+-\\S+-\\S+";
    private static Pattern pattern = Pattern.compile("PR-\\d+-\\S+-\\S+");

    public static boolean isHidden(String branch) {
        return pattern.matcher(branch).matches();
    }

    public Map<String, Ref> filter(Map<String, Ref> refs) {
        return refs.entrySet().stream().filter((? super T ref) -> !HiddenBranchRefFilter.isHidden((String)ref.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

