/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.merge.ThreeWayMerger;
import org.eclipse.jgit.revwalk.RevCommit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.java.nio.fs.jgit.util.JGitUtil;
import org.uberfire.java.nio.fs.jgit.util.commands.GitCommand;
import org.uberfire.java.nio.fs.jgit.util.exceptions.GitException;

public class Merge
extends GitCommand {
    private final Git git;
    private final String sourceBranch;
    private final String targetBranch;
    private Logger logger = LoggerFactory.getLogger(Merge.class);

    public Merge(Git git, String sourceBranch, String targetBranch) {
        this.git = (Git)PortablePreconditions.checkNotNull((String)"git", (Object)git);
        this.sourceBranch = PortablePreconditions.checkNotEmpty((String)"sourceBranch", (String)sourceBranch);
        this.targetBranch = PortablePreconditions.checkNotEmpty((String)"targetBranch", (String)targetBranch);
    }

    public Optional<List<String>> execute() {
        this.existsBranch(this.git, this.sourceBranch);
        this.existsBranch(this.git, this.targetBranch);
        Repository repo = this.git.getRepository();
        RevCommit lastSourceCommit = JGitUtil.getLastCommit(this.git, this.sourceBranch);
        RevCommit lastTargetCommit = JGitUtil.getLastCommit(this.git, this.targetBranch);
        RevCommit commonAncestor = JGitUtil.getCommonAncestor(this.git, (ObjectId)lastSourceCommit, (ObjectId)lastTargetCommit);
        List<RevCommit> commits = JGitUtil.getCommits(this.git, this.sourceBranch, (ObjectId)commonAncestor, (ObjectId)lastSourceCommit);
        Collections.reverse(commits);
        String[] commitsIDs = (String[])commits.stream().map(elem -> elem.getName()).toArray(String[]::new);
        this.canMerge(repo, commonAncestor, lastSourceCommit, lastTargetCommit, this.sourceBranch, this.targetBranch);
        JGitUtil.cherryPick(repo, this.targetBranch, commitsIDs);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Merging commits from <{}> to <{}>", (Object)this.sourceBranch, (Object)this.targetBranch);
        }
        return Optional.ofNullable(Arrays.asList(commitsIDs));
    }

    private void canMerge(Repository repo, RevCommit commonAncestor, RevCommit sourceCommitTree, RevCommit targetCommitTree, String sourceBranch, String targetBranch) {
        try {
            ThreeWayMerger merger = MergeStrategy.RECURSIVE.newMerger(repo, true);
            merger.setBase((AnyObjectId)commonAncestor);
            boolean canMerge = merger.merge(new AnyObjectId[]{sourceCommitTree, targetCommitTree});
            if (!canMerge) {
                throw new GitException(String.format("Cannot merge braches from <%s> to <%s>, merge conflicts", sourceBranch, targetBranch));
            }
        }
        catch (IOException e) {
            throw new GitException(String.format("Cannot merge braches from <%s> to <%s>, merge conflicts", sourceBranch, targetBranch), e);
        }
    }

    private void existsBranch(Git git, String branch) {
        if (JGitUtil.getBranch(git, branch) == null) {
            throw new GitException(String.format("Branch <<%s>> does not exists", branch));
        }
    }
}

