/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.registry;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.NotAcceptableException;
import javax.ws.rs.NotAllowedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.core.ResourceInvoker;
import org.jboss.resteasy.core.ResourceLocatorInvoker;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.registry.MethodExpression;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.DefaultOptionsMethodException;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.ResteasyUriInfo;
import org.jboss.resteasy.util.WeightedMediaType;

public class SegmentNode {
    public static final String RESTEASY_CHOSEN_ACCEPT = "RESTEASY_CHOSEN_ACCEPT";
    public static final MediaType[] WILDCARD_ARRAY = new MediaType[]{MediaType.WILDCARD_TYPE};
    public static final List<MediaType> DEFAULT_ACCEPTS = new ArrayList<MediaType>();
    protected String segment;
    protected Map<String, SegmentNode> children = new HashMap<String, SegmentNode>();
    protected List<MethodExpression> targets = new ArrayList<MethodExpression>();

    public SegmentNode(String segment) {
        this.segment = segment;
    }

    public ResourceInvoker match(HttpRequest request, int start) {
        String path = request.getUri().getMatchingPath();
        if (start < path.length() && path.charAt(start) == '/') {
            ++start;
        }
        ArrayList<MethodExpression> potentials = new ArrayList<MethodExpression>();
        this.potentials(path, start, potentials);
        Collections.sort(potentials);
        boolean expressionMatched = false;
        ArrayList<Match> matches = new ArrayList<Match>();
        for (MethodExpression expression : potentials) {
            if (expressionMatched && expression.isLocator()) continue;
            Pattern pattern = expression.getPattern();
            Matcher matcher = pattern.matcher(path);
            matcher.region(start, path.length());
            if (!matcher.matches()) continue;
            expressionMatched = true;
            ResourceInvoker invoker = expression.getInvoker();
            if (invoker instanceof ResourceLocatorInvoker) {
                ResteasyUriInfo uriInfo = request.getUri();
                int length = matcher.start(expression.getNumGroups() + 1);
                if (length == -1) {
                    uriInfo.pushMatchedPath(path);
                    uriInfo.pushMatchedURI(path);
                } else {
                    String substring = path.substring(0, length);
                    uriInfo.pushMatchedPath(substring);
                    uriInfo.pushMatchedURI(substring);
                }
                expression.populatePathParams(request, matcher, path);
                return invoker;
            }
            matches.add(new Match(expression, matcher));
        }
        if (matches.size() == 0) {
            throw new NotFoundException(Messages.MESSAGES.couldNotFindResourceForFullPath(request.getUri().getRequestUri()));
        }
        Match match = this.match(matches, request.getHttpMethod(), request);
        match.expression.populatePathParams(request, match.matcher, path);
        return match.expression.getInvoker();
    }

    public void potentials(String path, int start, List<MethodExpression> matches) {
        if (start == path.length()) {
            matches.addAll(this.targets);
            return;
        }
        if (start < path.length()) {
            String simpleSegment = null;
            int endOfSegmentIndex = path.indexOf(47, start);
            simpleSegment = endOfSegmentIndex > -1 ? path.substring(start, endOfSegmentIndex) : path.substring(start);
            SegmentNode child = this.children.get(simpleSegment);
            if (child != null) {
                int next = start + simpleSegment.length();
                if (endOfSegmentIndex > -1) {
                    ++next;
                }
                child.potentials(path, next, matches);
            }
        }
        for (MethodExpression exp : this.targets) {
            if (exp.getNumGroups() <= 0 && !(exp.getInvoker() instanceof ResourceLocatorInvoker)) continue;
            matches.add(exp);
        }
    }

    public static SortFactor createSortFactor(MediaType client, MediaType server) {
        String val;
        String name;
        String qs;
        SortFactor sortFactor = new SortFactor();
        if (client.isWildcardType() != server.isWildcardType()) {
            sortFactor.type = client.isWildcardType() ? server.getType() : client.getType();
            ++sortFactor.d;
        } else {
            sortFactor.type = client.getType();
        }
        if (client.isWildcardSubtype() != server.isWildcardSubtype()) {
            sortFactor.subtype = client.isWildcardSubtype() ? server.getSubtype() : client.getSubtype();
            ++sortFactor.d;
        } else {
            sortFactor.subtype = client.getSubtype();
        }
        String q = (String)client.getParameters().get("q");
        if (q != null) {
            sortFactor.q = Float.parseFloat(q);
        }
        if ((qs = (String)server.getParameters().get("qs")) != null) {
            sortFactor.qs = Float.parseFloat(qs);
        }
        sortFactor.dm = 0;
        for (Map.Entry entry : client.getParameters().entrySet()) {
            name = (String)entry.getKey();
            if ("q".equals(name) || "qs".equals(name)) continue;
            val = (String)server.getParameters().get(name);
            if (val == null) {
                ++sortFactor.dm;
                continue;
            }
            if (val.equals(entry.getValue())) continue;
            ++sortFactor.dm;
        }
        for (Map.Entry entry : server.getParameters().entrySet()) {
            name = (String)entry.getKey();
            if ("q".equals(name) || "qs".equals(name)) continue;
            val = (String)client.getParameters().get(name);
            if (val == null) {
                ++sortFactor.dm;
                continue;
            }
            if (val.equals(entry.getValue())) continue;
            ++sortFactor.dm;
        }
        return sortFactor;
    }

    /*
     * WARNING - void declaration
     */
    public Match match(List<Match> matches, String httpMethod, HttpRequest request) {
        MediaType contentType = request.getHttpHeaders().getMediaType();
        List<MediaType> requestAccepts = request.getHttpHeaders().getAcceptableMediaTypes();
        ArrayList<WeightedMediaType> weightedAccepts = new ArrayList<WeightedMediaType>();
        for (MediaType accept : requestAccepts) {
            weightedAccepts.add(WeightedMediaType.parse(accept));
        }
        ArrayList<Match> list = new ArrayList<Match>();
        boolean methodMatch = false;
        boolean consumeMatch = false;
        for (Match match : matches) {
            ResourceMethodInvoker invoker = (ResourceMethodInvoker)match.expression.getInvoker();
            if (!invoker.getHttpMethods().contains(httpMethod.toUpperCase())) continue;
            methodMatch = true;
            if (!invoker.doesConsume(contentType)) continue;
            consumeMatch = true;
            if (!invoker.doesProduce(weightedAccepts)) continue;
            list.add(match);
        }
        if (list.size() == 0) {
            if (!methodMatch) {
                void var11_15;
                HashSet<String> allowed = new HashSet<String>();
                for (Match match : matches) {
                    allowed.addAll(((ResourceMethodInvoker)match.expression.getInvoker()).getHttpMethods());
                }
                if (httpMethod.equalsIgnoreCase("HEAD") && allowed.contains("GET")) {
                    return this.match(matches, "GET", request);
                }
                if (allowed.contains("GET")) {
                    allowed.add("HEAD");
                }
                allowed.add("OPTIONS");
                String string = "";
                boolean first = true;
                for (String allow : allowed) {
                    void var11_17;
                    if (first) {
                        first = false;
                    } else {
                        String string2 = (String)var11_15 + ", ";
                    }
                    String string3 = (String)var11_17 + allow;
                }
                if (httpMethod.equals("OPTIONS")) {
                    Response response = Response.ok((Object)var11_15, (MediaType)MediaType.TEXT_PLAIN_TYPE).header("Allow", (Object)var11_15).build();
                    throw new DefaultOptionsMethodException(Messages.MESSAGES.noResourceMethodFoundForOptions(), response);
                }
                Response response = Response.status((int)405).header("Allow", (Object)var11_15).build();
                throw new NotAllowedException(Messages.MESSAGES.noResourceMethodFoundForHttpMethod(httpMethod), response);
            }
            if (!consumeMatch) {
                throw new NotSupportedException(Messages.MESSAGES.cannotConsumeContentType());
            }
            throw new NotAcceptableException(Messages.MESSAGES.noMatchForAcceptHeader());
        }
        ArrayList<SortEntry> sortList = new ArrayList<SortEntry>();
        HashSet<Method> hashSet = new HashSet<Method>();
        for (Match match : list) {
            MediaType[] produces;
            MediaType[] consumes;
            ResourceMethodInvoker invoker = (ResourceMethodInvoker)match.expression.getInvoker();
            if (contentType == null) {
                contentType = MediaType.WILDCARD_TYPE;
            }
            if ((consumes = invoker.getConsumes()).length == 0) {
                consumes = WILDCARD_ARRAY;
            }
            if ((produces = invoker.getProduces()).length == 0) {
                produces = WILDCARD_ARRAY;
            }
            ArrayList<SortFactor> consumeCombo = new ArrayList<SortFactor>();
            for (MediaType consume : consumes) {
                consumeCombo.add(SegmentNode.createSortFactor(contentType, consume));
            }
            for (MediaType produce : produces) {
                List<MediaType> acceptableMediaTypes = requestAccepts;
                if (acceptableMediaTypes.size() == 0) {
                    acceptableMediaTypes = DEFAULT_ACCEPTS;
                }
                for (MediaType accept : acceptableMediaTypes) {
                    if (!accept.isCompatible(produce)) continue;
                    SortFactor sortFactor = SegmentNode.createSortFactor(accept, produce);
                    for (SortFactor consume : consumeCombo) {
                        sortList.add(new SortEntry(match, consume, sortFactor, produce));
                        hashSet.add(match.expression.getInvoker().getMethod());
                    }
                }
            }
        }
        Collections.sort(sortList);
        SortEntry sortEntry = (SortEntry)sortList.get(0);
        if (hashSet.size() > 1) {
            LogMessages.LOGGER.multipleMethodsMatch(this.requestToString(request), this.methodNames(hashSet));
        }
        request.setAttribute(RESTEASY_CHOSEN_ACCEPT, sortEntry.getAcceptType());
        return sortEntry.match;
    }

    protected void addExpression(MethodExpression expression) {
        this.targets.add(expression);
        Collections.sort(this.targets);
    }

    private String requestToString(HttpRequest request) {
        return "\"" + request.getHttpMethod() + " " + request.getUri().getPath() + "\"";
    }

    private String[] methodNames(Collection<Method> methods) {
        String[] names = new String[methods.size()];
        Iterator<Method> iterator = methods.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            names[i++] = iterator.next().toString();
        }
        return names;
    }

    static {
        DEFAULT_ACCEPTS.add(MediaType.WILDCARD_TYPE);
    }

    protected class SortEntry
    implements Comparable<SortEntry> {
        Match match;
        MediaType serverProduce;
        SortFactor consumes;
        SortFactor produces;

        public SortEntry(Match match, SortFactor consumes, SortFactor produces, MediaType serverProduce) {
            this.serverProduce = serverProduce;
            this.match = match;
            this.consumes = consumes;
            this.produces = produces;
        }

        public MediaType getAcceptType() {
            HashMap params = new HashMap();
            for (Map.Entry entry : this.serverProduce.getParameters().entrySet()) {
                String name = (String)entry.getKey();
                if ("q".equals(name) || "qs".equals(name)) continue;
                params.put(name, entry.getValue());
            }
            return new MediaType(this.produces.type, this.produces.subtype, params);
        }

        @Override
        public int compareTo(SortEntry o) {
            if (this.consumes.isWildcardType() && !o.consumes.isWildcardType()) {
                return 1;
            }
            if (!this.consumes.isWildcardType() && o.consumes.isWildcardType()) {
                return -1;
            }
            if (this.consumes.isWildcardSubtype() && !o.consumes.isWildcardSubtype()) {
                return 1;
            }
            if (!this.consumes.isWildcardSubtype() && o.consumes.isWildcardSubtype()) {
                return -1;
            }
            if (this.consumes.q > o.consumes.q) {
                return -1;
            }
            if (this.consumes.q < o.consumes.q) {
                return 1;
            }
            if (this.consumes.qs > o.consumes.qs) {
                return -1;
            }
            if (this.consumes.qs < o.consumes.qs) {
                return 1;
            }
            if (this.consumes.d < o.consumes.d) {
                return -1;
            }
            if (this.consumes.d > o.consumes.d) {
                return 1;
            }
            if (this.consumes.dm < o.consumes.dm) {
                return -1;
            }
            if (this.consumes.dm > o.consumes.dm) {
                return 1;
            }
            if (this.produces.isWildcardType() && !o.produces.isWildcardType()) {
                return 1;
            }
            if (!this.produces.isWildcardType() && o.produces.isWildcardType()) {
                return -1;
            }
            if (this.produces.isWildcardSubtype() && !o.produces.isWildcardSubtype()) {
                return 1;
            }
            if (!this.produces.isWildcardSubtype() && o.produces.isWildcardSubtype()) {
                return -1;
            }
            if (this.produces.q > o.produces.q) {
                return -1;
            }
            if (this.produces.q < o.produces.q) {
                return 1;
            }
            if (this.produces.qs > o.produces.qs) {
                return -1;
            }
            if (this.produces.qs < o.produces.qs) {
                return 1;
            }
            if (this.produces.d < o.produces.d) {
                return -1;
            }
            if (this.produces.d > o.produces.d) {
                return 1;
            }
            if (this.produces.dm < o.produces.dm) {
                return -1;
            }
            if (this.produces.dm > o.produces.dm) {
                return 1;
            }
            return this.match.expression.compareTo(o.match.expression);
        }
    }

    public static class SortFactor {
        public float q = 1.0f;
        public float qs = 1.0f;
        public int d;
        public int dm;
        public String type;
        public String subtype;
        public Map<String, String> params;

        public boolean isWildcardType() {
            return this.type.equals("*");
        }

        public boolean isWildcardSubtype() {
            return this.subtype.equals("*");
        }
    }

    protected static class Match {
        MethodExpression expression;
        Matcher matcher;

        public Match(MethodExpression expression, Matcher matcher) {
            this.expression = expression;
            this.matcher = matcher;
        }
    }
}

