/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix;

import org.apache.helix.Type;

public enum PropertyType {
    CONFIGS(Type.CLUSTER, true, false, false, false, true),
    LIVEINSTANCES(Type.CLUSTER, false, false, false, true, true),
    INSTANCES(Type.CLUSTER, true, false),
    IDEALSTATES(Type.CLUSTER, true, false, false, false, true),
    EXTERNALVIEW(Type.CLUSTER, true, false),
    STATEMODELDEFS(Type.CLUSTER, true, false, false, false, true),
    CONTROLLER(Type.CLUSTER, true, false),
    PROPERTYSTORE(Type.CLUSTER, true, false),
    MESSAGES(Type.INSTANCE, true, true, true),
    CURRENTSTATES(Type.INSTANCE, true, true, false, false, true),
    STATUSUPDATES(Type.INSTANCE, true, true, false, false, false, true),
    ERRORS(Type.INSTANCE, true, true),
    HEALTHREPORT(Type.INSTANCE, true, false, false, false, false, true),
    LEADER(Type.CONTROLLER, false, false, true, true),
    HISTORY(Type.CONTROLLER, true, true, true),
    PAUSE(Type.CONTROLLER, true, false, true),
    MESSAGES_CONTROLLER(Type.CONTROLLER, true, false, true),
    STATUSUPDATES_CONTROLLER(Type.CONTROLLER, true, true, true),
    ERRORS_CONTROLLER(Type.CONTROLLER, true, true, true);

    Type type;
    boolean isPersistent;
    boolean mergeOnUpdate;
    boolean updateOnlyOnExists;
    boolean createOnlyIfAbsent;
    boolean isCached;

    private PropertyType(Type type, boolean isPersistent, boolean mergeOnUpdate) {
        this(type, isPersistent, mergeOnUpdate, false);
    }

    private PropertyType(Type type, boolean isPersistent, boolean mergeOnUpdate, boolean updateOnlyOnExists) {
        this(type, isPersistent, mergeOnUpdate, false, false);
    }

    private PropertyType(Type type, boolean isPersistent, boolean mergeOnUpdate, boolean updateOnlyOnExists, boolean createOnlyIfAbsent) {
        this(type, isPersistent, mergeOnUpdate, updateOnlyOnExists, createOnlyIfAbsent, false);
    }

    private PropertyType(Type type, boolean isPersistent, boolean mergeOnUpdate, boolean updateOnlyOnExists, boolean createOnlyIfAbsent, boolean isCached) {
        this(type, isPersistent, mergeOnUpdate, updateOnlyOnExists, createOnlyIfAbsent, isCached, false);
    }

    private PropertyType(Type type, boolean isPersistent, boolean mergeOnUpdate, boolean updateOnlyOnExists, boolean createOnlyIfAbsent, boolean isCached, boolean isAsyncWrite) {
        this.type = type;
        this.isPersistent = isPersistent;
        this.mergeOnUpdate = mergeOnUpdate;
        this.updateOnlyOnExists = updateOnlyOnExists;
        this.createOnlyIfAbsent = createOnlyIfAbsent;
        this.isCached = isCached;
    }

    public boolean isCreateOnlyIfAbsent() {
        return this.createOnlyIfAbsent;
    }

    public void setCreateIfAbsent(boolean createIfAbsent) {
        this.createOnlyIfAbsent = createIfAbsent;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public boolean isPersistent() {
        return this.isPersistent;
    }

    public void setPersistent(boolean isPersistent) {
        this.isPersistent = isPersistent;
    }

    public boolean isMergeOnUpdate() {
        return this.mergeOnUpdate;
    }

    public void setMergeOnUpdate(boolean mergeOnUpdate) {
        this.mergeOnUpdate = mergeOnUpdate;
    }

    public boolean isUpdateOnlyOnExists() {
        return this.updateOnlyOnExists;
    }

    public void setUpdateOnlyOnExists(boolean updateOnlyOnExists) {
        this.updateOnlyOnExists = updateOnlyOnExists;
    }

    public boolean isCached() {
        return this.isCached;
    }
}

