/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.access;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.clerezza.rdf.core.Graph;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.Triple;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.access.LockableMGraph;
import org.apache.clerezza.rdf.core.access.LockingIterator;
import org.apache.clerezza.rdf.core.access.debug.ReentrantReadWriteLockTracker;
import org.apache.clerezza.rdf.core.event.FilterTriple;
import org.apache.clerezza.rdf.core.event.GraphListener;

public class LockableMGraphWrapper
implements LockableMGraph {
    private static final String DEBUG_MODE = "rdfLocksDebugging";
    private final ReadWriteLock lock;
    private final Lock readLock;
    private final Lock writeLock;
    private final MGraph wrapped;

    public LockableMGraphWrapper(MGraph providedMGraph) {
        String debugMode = System.getProperty(DEBUG_MODE);
        this.lock = debugMode != null && debugMode.toLowerCase().equals("true") ? new ReentrantReadWriteLockTracker() : new ReentrantReadWriteLock();
        this.readLock = this.lock.readLock();
        this.writeLock = this.lock.writeLock();
        this.wrapped = providedMGraph;
    }

    @Override
    public ReadWriteLock getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Graph getGraph() {
        this.readLock.lock();
        try {
            Graph graph = this.wrapped.getGraph();
            return graph;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Triple> filter(NonLiteral subject, UriRef predicate, Resource object) {
        this.readLock.lock();
        try {
            LockingIterator lockingIterator = new LockingIterator(this.wrapped.filter(subject, predicate, object), this.lock);
            return lockingIterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        this.readLock.lock();
        try {
            int n = this.wrapped.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        this.readLock.lock();
        try {
            boolean bl = this.wrapped.isEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        this.readLock.lock();
        try {
            boolean bl = this.wrapped.contains(o);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Triple> iterator() {
        this.readLock.lock();
        try {
            LockingIterator lockingIterator = new LockingIterator(this.wrapped.iterator(), this.lock);
            return lockingIterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        this.readLock.lock();
        try {
            Object[] objectArray = this.wrapped.toArray();
            return objectArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        this.readLock.lock();
        try {
            T[] TArray = this.wrapped.toArray(a);
            return TArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> c) {
        this.readLock.lock();
        try {
            boolean bl = this.wrapped.containsAll(c);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Triple e) {
        this.writeLock.lock();
        try {
            boolean bl = this.wrapped.add(e);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        this.writeLock.lock();
        try {
            boolean bl = this.wrapped.remove(o);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends Triple> c) {
        this.writeLock.lock();
        try {
            boolean bl = this.wrapped.addAll(c);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        this.writeLock.lock();
        try {
            boolean bl = this.wrapped.removeAll(c);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        this.writeLock.lock();
        try {
            boolean bl = this.wrapped.retainAll(c);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.writeLock.lock();
        try {
            this.wrapped.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void addGraphListener(GraphListener listener, FilterTriple filter, long delay) {
        this.wrapped.addGraphListener(listener, filter, delay);
    }

    @Override
    public void addGraphListener(GraphListener listener, FilterTriple filter) {
        this.wrapped.addGraphListener(listener, filter);
    }

    @Override
    public void removeGraphListener(GraphListener listener) {
        this.wrapped.removeGraphListener(listener);
    }
}

