/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.Event;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.Dependent;

@Dependent
public class LockDemandDetector {
    private static final List<String> TAG_CLICK_LOCK_EXCLUSIONS = Arrays.asList("a", "select", "input", "textarea", "table", "tbody", "tfoot", "td", "tr");

    public boolean isLockRequired(Event event) {
        boolean click;
        Element target = Element.as((JavaScriptObject)event.getEventTarget());
        String lockAttribute = this.findLockAttribute("data-uf-lock", target);
        if (lockAttribute != null && !lockAttribute.isEmpty()) {
            return Boolean.parseBoolean(lockAttribute);
        }
        boolean bl = click = event.getTypeInt() == 1;
        if (click) {
            String lockOnClickAttribute = this.findLockAttribute("data-uf-lock-on-click", target);
            if (lockOnClickAttribute != null && !lockOnClickAttribute.isEmpty()) {
                return Boolean.parseBoolean(lockOnClickAttribute);
            }
            return !TAG_CLICK_LOCK_EXCLUSIONS.contains(target.getTagName().toLowerCase());
        }
        return true;
    }

    public int getLockDemandEventTypes() {
        return 526209;
    }

    private String findLockAttribute(String attributeName, Element element) {
        if (element == null) {
            return null;
        }
        String lockAttribute = element.getAttribute(attributeName);
        if (lockAttribute != null && !lockAttribute.isEmpty()) {
            return lockAttribute;
        }
        return this.findLockAttribute(attributeName, element.getParentElement());
    }
}

