/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.widgets.menu.megamenu.visitor;

import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.widgets.menu.base.WorkbenchBaseMenuUtils;
import org.uberfire.client.workbench.widgets.menu.megamenu.WorkbenchMegaMenuPresenter;
import org.uberfire.workbench.model.menu.MenuCustom;
import org.uberfire.workbench.model.menu.MenuGroup;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuItemCommand;
import org.uberfire.workbench.model.menu.MenuItemPerspective;
import org.uberfire.workbench.model.menu.MenuItemPlain;
import org.uberfire.workbench.model.menu.impl.BaseMenuVisitor;

public class WorkbenchMegaMenuContextMenuVisitor
extends BaseMenuVisitor {
    private WorkbenchMegaMenuPresenter presenter;
    private PlaceManager placeManager;
    private String perspectiveId;
    private String parentId = null;

    public WorkbenchMegaMenuContextMenuVisitor(WorkbenchMegaMenuPresenter presenter, PlaceManager placeManager, String perspectiveId) {
        this.presenter = presenter;
        this.placeManager = placeManager;
        this.perspectiveId = perspectiveId;
    }

    public boolean visitEnter(MenuGroup menuGroup) {
        this.parentId = WorkbenchBaseMenuUtils.getMenuItemId((MenuItem)menuGroup);
        this.presenter.addContextGroupMenuItem(this.perspectiveId, this.parentId, menuGroup.getCaption(), menuGroup.getPosition());
        return true;
    }

    public void visitLeave(MenuGroup menuGroup) {
        this.parentId = null;
    }

    public void visit(MenuItemPlain menuItemPlain) {
        this.presenter.addContextMenuItem(this.perspectiveId, WorkbenchBaseMenuUtils.getMenuItemId((MenuItem)menuItemPlain), menuItemPlain.getCaption(), this.parentId, null, menuItemPlain.getPosition());
        this.setupEnableDisableContextMenuItem((MenuItem)menuItemPlain);
    }

    public void visit(MenuCustom<?> menuCustom) {
        this.presenter.addContextMenuItem(this.perspectiveId, WorkbenchBaseMenuUtils.getMenuItemId(menuCustom), menuCustom.getCaption(), this.parentId, null, menuCustom.getPosition());
        this.setupEnableDisableContextMenuItem((MenuItem)menuCustom);
    }

    public void visit(MenuItemCommand menuItemCommand) {
        this.presenter.addContextMenuItem(this.perspectiveId, WorkbenchBaseMenuUtils.getMenuItemId((MenuItem)menuItemCommand), menuItemCommand.getCaption(), this.parentId, menuItemCommand.getCommand(), menuItemCommand.getPosition());
        this.setupEnableDisableContextMenuItem((MenuItem)menuItemCommand);
    }

    public void visit(MenuItemPerspective menuItemPerspective) {
        this.presenter.addContextMenuItem(this.perspectiveId, menuItemPerspective.getPlaceRequest().getIdentifier(), menuItemPerspective.getCaption(), this.parentId, () -> this.placeManager.goTo(menuItemPerspective.getPlaceRequest()), menuItemPerspective.getPosition());
        this.setupEnableDisableContextMenuItem((MenuItem)menuItemPerspective);
    }

    private void setupEnableDisableContextMenuItem(MenuItem menuItem) {
        menuItem.addEnabledStateChangeListener(enabled -> this.presenter.enableContextMenuItem(WorkbenchBaseMenuUtils.getMenuItemId(menuItem), enabled));
    }
}

