/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.authz;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.authz.AuthorizationPolicyStorage;
import org.uberfire.backend.server.authz.AuthorizationPolicyMarshaller;
import org.uberfire.backend.server.authz.NonEscapedProperties;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.FileVisitResult;
import org.uberfire.java.nio.file.FileVisitor;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Option;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.SimpleFileVisitor;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.security.authz.AuthorizationPolicy;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.security.impl.authz.AuthorizationPolicyBuilder;
import org.uberfire.spaces.SpacesAPI;

@ApplicationScoped
public class AuthorizationPolicyVfsStorage
implements AuthorizationPolicyStorage {
    private Logger logger = LoggerFactory.getLogger(AuthorizationPolicyVfsStorage.class);
    private PermissionManager permissionManager;
    private SpacesAPI spaces;
    private IOService ioService;
    private FileSystem fileSystem;
    private Path root;

    public AuthorizationPolicyVfsStorage() {
    }

    @Inject
    public AuthorizationPolicyVfsStorage(@Named(value="configIO") IOService ioService, PermissionManager permissionManager, SpacesAPI spaces) {
        this.ioService = ioService;
        this.permissionManager = permissionManager;
        this.spaces = spaces;
    }

    @PostConstruct
    private synchronized void init() {
        this.initFileSystem();
    }

    public synchronized AuthorizationPolicy loadPolicy() {
        return this.loadPolicyFromVfs();
    }

    public synchronized void savePolicy(AuthorizationPolicy policy) {
        this.savePolicyIntoVfs(policy, "system", "Save policy");
    }

    public void initFileSystem() {
        try {
            this.fileSystem = this.ioService.newFileSystem(this.spaces.resolveFileSystemURI(SpacesAPI.Scheme.DEFAULT, SpacesAPI.DEFAULT_SPACE, "security"), (Map)new HashMap<String, Object>(){
                {
                    this.put("init", Boolean.TRUE);
                    this.put("internal", Boolean.TRUE);
                }
            });
        }
        catch (FileSystemAlreadyExistsException e) {
            this.fileSystem = this.ioService.getFileSystem(this.spaces.resolveFileSystemURI(SpacesAPI.Scheme.DEFAULT, SpacesAPI.DEFAULT_SPACE, "security"));
        }
        this.root = (Path)this.fileSystem.getRootDirectories().iterator().next();
    }

    public AuthorizationPolicy loadPolicyFromVfs() {
        Path authzPath = this.getAuthzPath();
        if (!this.ioService.exists(authzPath)) {
            return null;
        }
        final AuthorizationPolicyBuilder builder = this.permissionManager.newAuthorizationPolicy();
        final AuthorizationPolicyMarshaller marshaller = new AuthorizationPolicyMarshaller();
        Files.walkFileTree((Path)authzPath, (FileVisitor)new SimpleFileVisitor<Path>(){

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                try {
                    PortablePreconditions.checkNotNull((String)"file", (Object)file);
                    PortablePreconditions.checkNotNull((String)"attrs", (Object)attrs);
                    if (AuthorizationPolicyVfsStorage.this.isPolicyFile(file)) {
                        String content = AuthorizationPolicyVfsStorage.this.ioService.readAllString(file);
                        NonEscapedProperties props = new NonEscapedProperties();
                        props.load(new StringReader(content));
                        marshaller.read(builder, props);
                    }
                }
                catch (Exception e) {
                    AuthorizationPolicyVfsStorage.this.logger.error("Authz policy file VFS read error: " + file.getFileName(), (Throwable)e);
                    return FileVisitResult.TERMINATE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return builder.build();
    }

    public boolean isPolicyFile(Path p) {
        String fileName = p.getName(p.getNameCount() - 1).toString();
        return fileName.equals("security-policy.properties") || fileName.startsWith("security-module-");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePolicyIntoVfs(AuthorizationPolicy policy, String subjectId, String message) {
        if (subjectId == null || message == null) {
            this.ioService.startBatch(this.fileSystem);
        } else {
            this.ioService.startBatch(this.fileSystem, new Option[]{new CommentedOption(subjectId, message)});
        }
        try {
            AuthorizationPolicyMarshaller marshaller = new AuthorizationPolicyMarshaller();
            NonEscapedProperties entries = new NonEscapedProperties();
            marshaller.write(policy, (Map)entries);
            StringWriter sw = new StringWriter();
            entries.store(sw, "Authorization Policy", "Last update: " + new Date().toString());
            String policyContent = sw.toString();
            Path policyPath = this.getAuthzPath().resolve("security-policy.properties");
            this.ioService.write(policyPath, policyContent, new OpenOption[0]);
        }
        catch (Exception e) {
            this.logger.error("Authz policy write error.", (Throwable)e);
        }
        finally {
            this.ioService.endBatch();
        }
    }

    public Path getAuthzPath() {
        PortablePreconditions.checkNotNull((String)"root", (Object)this.root);
        return this.root.resolve("authz");
    }
}

