/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.jgit.internal.ketch.KetchLeaderCache;
import org.eclipse.jgit.internal.storage.file.WindowCache;
import org.eclipse.jgit.storage.file.WindowCacheConfig;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.util.FileUtils;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.data.Pair;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.fs.jgit.util.Git;

public class Clone {
    public static final String REFS_MIRRORED = "+refs/heads/*:refs/remotes/origin/*";
    private final File repoDir;
    private final String origin;
    private final CredentialsProvider credentialsProvider;
    private final boolean isMirror;
    private final KetchLeaderCache leaders;
    private final File hookDir;
    private Logger logger = LoggerFactory.getLogger(Clone.class);

    public Clone(File directory, String origin, boolean isMirror, CredentialsProvider credentialsProvider, KetchLeaderCache leaders, File hookDir) {
        this.repoDir = (File)PortablePreconditions.checkNotNull((String)"directory", (Object)directory);
        this.origin = PortablePreconditions.checkNotEmpty((String)"origin", (String)origin);
        this.isMirror = isMirror;
        this.credentialsProvider = credentialsProvider;
        this.leaders = leaders;
        this.hookDir = hookDir;
    }

    public Optional<Git> execute() {
        if (this.repoDir.exists()) {
            String message = String.format("Cannot clone because destination repository <%s> already exists", this.repoDir.getAbsolutePath());
            this.logger.error(message);
            throw new CloneException(message);
        }
        Git git = Git.createRepository(this.repoDir, this.hookDir);
        if (git != null) {
            try {
                List<Object> refSpecList = this.isMirror ? Collections.singletonList(new RefSpec(REFS_MIRRORED)) : Collections.emptyList();
                Pair remote = Pair.newPair((Object)"origin", (Object)this.origin);
                git.fetch(this.credentialsProvider, (Pair<String, String>)remote, refSpecList);
                git.syncRemote((Pair<String, String>)remote);
                if (git.isKetchEnabled()) {
                    git.convertRefTree();
                    git.updateLeaders(this.leaders);
                }
                git.setHeadAsInitialized();
                return Optional.of(git);
            }
            catch (Exception e) {
                String message = String.format("Error cloning origin <%s>.", this.origin);
                this.logger.error(message);
                this.cleanupDir(git.getRepository().getDirectory());
                throw new CloneException(message, e);
            }
        }
        return Optional.empty();
    }

    private void cleanupDir(File gitDir) {
        try {
            if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                WindowCache.reconfigure((WindowCacheConfig)new WindowCacheConfig());
            }
            FileUtils.delete((File)gitDir, (int)3);
        }
        catch (java.io.IOException e) {
            throw new IOException("Failed to remove the git repository.", (Exception)e);
        }
    }

    public static class CloneException
    extends RuntimeException {
        public CloneException(String message) {
            super(message);
        }

        public CloneException(String message, Throwable t) {
            super(message, t);
        }
    }
}

