/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.dom;

import elemental2.core.JsObject;
import elemental2.promise.Promise;
import java.lang.Object;
import java.lang.String;
import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface FontFaceSet extends EventTarget {
  @JsFunction
  public interface ForEachCbCallbackFn {
    Object onInvoke(FontFace p0, double p1, FontFaceSet p2);
  }

  @JsFunction
  public interface OnloadingCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnloadingdoneCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnloadingerrorCallbackFn {
    Object onInvoke(Event p0);
  }

  void add(FontFace value);

  boolean check(String font, String text);

  boolean check(String font);

  void clear();

  void delete(FontFace value);

  void forEach(ForEachCbCallbackFn cb, JsObject selfObj);

  void forEach(ForEachCbCallbackFn cb);

  @JsProperty
  OnloadingCallbackFn getOnloading();

  @JsProperty
  OnloadingdoneCallbackFn getOnloadingdone();

  @JsProperty
  OnloadingerrorCallbackFn getOnloadingerror();

  @JsProperty
  Promise<FontFaceSet> getReady();

  @JsProperty
  String getStatus();

  boolean has(FontFace font);

  Promise<FontFace[]> load(String font, String text);

  Promise<FontFace[]> load(String font);

  @JsProperty
  void setOnloading(OnloadingCallbackFn onloading);

  @JsProperty
  void setOnloadingdone(OnloadingdoneCallbackFn onloadingdone);

  @JsProperty
  void setOnloadingerror(OnloadingerrorCallbackFn onloadingerror);

  @JsProperty
  void setReady(Promise<FontFaceSet> ready);

  @JsProperty
  void setStatus(String status);
}
