/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.io.watch;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.naming.InitialContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.io.watch.AsyncWatchService;
import org.uberfire.backend.server.io.watch.IOWatchServiceExecutor;
import org.uberfire.backend.server.io.watch.IOWatchServiceExecutorImpl;
import org.uberfire.backend.server.util.Filter;
import org.uberfire.commons.async.DescriptiveRunnable;
import org.uberfire.commons.concurrent.Unmanaged;
import org.uberfire.commons.services.cdi.ApplicationStarted;
import org.uberfire.io.IOWatchService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.WatchEvent;
import org.uberfire.java.nio.file.WatchKey;
import org.uberfire.java.nio.file.WatchService;
import org.uberfire.workbench.events.ResourceAddedEvent;
import org.uberfire.workbench.events.ResourceBatchChangesEvent;
import org.uberfire.workbench.events.ResourceDeletedEvent;
import org.uberfire.workbench.events.ResourceRenamedEvent;
import org.uberfire.workbench.events.ResourceUpdatedEvent;

public abstract class AbstractIOWatchService
implements IOWatchService,
Filter<WatchEvent<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractIOWatchService.class);
    private static final Integer AWAIT_TERMINATION_TIMEOUT = Integer.parseInt(System.getProperty("org.uberfire.watcher.quitetimeout", "3"));
    private final List<String> fileSystems = new ArrayList<String>();
    private final List<WatchService> watchServices = new ArrayList<WatchService>();
    protected boolean isDisposed = false;
    private boolean started;
    private final Set<AsyncWatchService> watchThreads = new HashSet<AsyncWatchService>();
    private Event<ResourceBatchChangesEvent> resourceBatchChanges;
    private Event<ResourceUpdatedEvent> resourceUpdatedEvent;
    private Event<ResourceRenamedEvent> resourceRenamedEvent;
    private Event<ResourceDeletedEvent> resourceDeletedEvent;
    private Event<ResourceAddedEvent> resourceAddedEvent;
    private ExecutorService executorService;
    private IOWatchServiceExecutor executor = null;
    private final Set<Future<?>> jobs = new CopyOnWriteArraySet();

    public AbstractIOWatchService() {
    }

    @Inject
    public AbstractIOWatchService(Event<ResourceBatchChangesEvent> resourceBatchChanges, Event<ResourceUpdatedEvent> resourceUpdatedEvent, Event<ResourceRenamedEvent> resourceRenamedEvent, Event<ResourceDeletedEvent> resourceDeletedEvent, Event<ResourceAddedEvent> resourceAddedEvent, @Unmanaged ExecutorService executorService) {
        this.resourceBatchChanges = resourceBatchChanges;
        this.resourceUpdatedEvent = resourceUpdatedEvent;
        this.resourceRenamedEvent = resourceRenamedEvent;
        this.resourceDeletedEvent = resourceDeletedEvent;
        this.resourceAddedEvent = resourceAddedEvent;
        this.executorService = executorService;
    }

    @PostConstruct
    public void initialize() {
        boolean autostart = Boolean.parseBoolean(System.getProperty("org.uberfire.watcher.autostart", "true"));
        if (autostart) {
            this.start();
        }
    }

    public synchronized void start() {
        if (!this.started) {
            this.started = true;
            for (final AsyncWatchService watchThread : this.watchThreads) {
                final IOWatchServiceExecutor watchServiceExecutor = this.getWatchServiceExecutor();
                this.jobs.add(this.executorService.submit((Runnable)new DescriptiveRunnable(){

                    public String getDescription() {
                        return watchThread.getDescription();
                    }

                    public void run() {
                        watchThread.execute(watchServiceExecutor);
                    }
                }));
            }
            this.watchThreads.clear();
        }
    }

    @PreDestroy
    protected void dispose() {
        this.isDisposed = true;
        for (WatchService watchService : this.watchServices) {
            watchService.close();
        }
        for (Future future : this.jobs) {
            if (future.isCancelled() || future.isDone()) continue;
            future.cancel(true);
        }
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(AWAIT_TERMINATION_TIMEOUT.intValue(), TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
                if (!this.executorService.awaitTermination(AWAIT_TERMINATION_TIMEOUT.intValue(), TimeUnit.SECONDS)) {
                    LOG.error("Thread pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public boolean hasWatchService(FileSystem fs) {
        return this.fileSystems.contains(fs.getName());
    }

    public void addWatchService(FileSystem fs, final WatchService ws) {
        this.fileSystems.add(fs.getName());
        this.watchServices.add(ws);
        final AsyncWatchService asyncWatchService = new AsyncWatchService(){

            @Override
            public void execute(IOWatchServiceExecutor wsExecutor) {
                while (!AbstractIOWatchService.this.isDisposed) {
                    boolean valid;
                    WatchKey wk;
                    try {
                        wk = ws.take();
                    }
                    catch (Exception ex) {
                        break;
                    }
                    try {
                        wsExecutor.execute(wk, AbstractIOWatchService.this);
                    }
                    catch (Exception ex) {
                        LOG.error("Unexpected error during WatchService execution", (Throwable)ex);
                    }
                    if (valid = wk.reset()) continue;
                    break;
                }
            }

            @Override
            public String getDescription() {
                return AbstractIOWatchService.this.getClass().getName() + "(" + ws.toString() + ")";
            }
        };
        if (this.started) {
            final IOWatchServiceExecutor watchServiceExecutor = this.getWatchServiceExecutor();
            this.executorService.execute((Runnable)new DescriptiveRunnable(){

                public String getDescription() {
                    return asyncWatchService.getDescription();
                }

                public void run() {
                    asyncWatchService.execute(watchServiceExecutor);
                }
            });
        } else {
            this.watchThreads.add(asyncWatchService);
        }
    }

    public void configureOnEvent(@Observes ApplicationStarted applicationStartedEvent) {
        this.start();
    }

    protected IOWatchServiceExecutor getWatchServiceExecutor() {
        if (this.executor == null) {
            IOWatchServiceExecutor _executor = null;
            try {
                _executor = (IOWatchServiceExecutor)InitialContext.doLookup("java:module/IOWatchServiceExecutorImpl");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (_executor == null) {
                _executor = new IOWatchServiceExecutorImpl();
                ((IOWatchServiceExecutorImpl)_executor).setEvents(this.resourceBatchChanges, this.resourceUpdatedEvent, this.resourceRenamedEvent, this.resourceDeletedEvent, this.resourceAddedEvent);
            }
            this.executor = _executor;
        }
        return this.executor;
    }
}

