/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.cdi.workspace;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.cdi.workspace.Workspace;
import org.uberfire.backend.server.cdi.model.WorkspaceImpl;
import org.uberfire.backend.server.cdi.workspace.WorkspaceManagerPreferences;

@ApplicationScoped
public class WorkspaceManager {
    private Logger logger = LoggerFactory.getLogger(WorkspaceManager.class);
    private WorkspaceManagerPreferences preferences;
    private ConcurrentHashMap<Workspace, Cache<String, Object>> workspaces;

    public WorkspaceManager() {
    }

    @Inject
    public WorkspaceManager(WorkspaceManagerPreferences workspaceManagerPreferences) {
        this.preferences = workspaceManagerPreferences;
    }

    @PostConstruct
    public void initialize() {
        this.workspaces = new ConcurrentHashMap();
    }

    public Workspace getOrCreateWorkspace(String name) {
        PortablePreconditions.checkNotNull((String)"name", (Object)name);
        WorkspaceImpl workspace = new WorkspaceImpl(name);
        this.workspaces.computeIfAbsent(new WorkspaceImpl(name), w -> this.createCache());
        return this.getWorkspace(name);
    }

    protected synchronized Cache<String, Object> createCache() {
        this.preferences.load();
        Cache cache = CacheBuilder.newBuilder().maximumSize((long)this.preferences.getCacheMaximumSize()).expireAfterAccess((long)this.preferences.getCacheExpirationTime(), TimeUnit.valueOf(this.preferences.getCacheExpirationUnit())).removalListener(removalNotification -> {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("[{},{}] {}", new Object[]{removalNotification.getKey().toString(), removalNotification.getValue().toString(), removalNotification.getCause().toString()});
            }
        }).build();
        return cache;
    }

    public Workspace getWorkspace(String name) {
        PortablePreconditions.checkNotNull((String)"name", (Object)name);
        Optional<Workspace> optionalWorkspace = this.workspaces.keySet().stream().filter(w -> name.equals(w.getName())).findAny();
        return optionalWorkspace.orElseThrow(() -> new NoSuchElementException(String.format("Workspace <<%s>> not found", name)));
    }

    public <T> T getBean(Workspace workspace, String beanName) {
        PortablePreconditions.checkNotNull((String)"workspace", (Object)workspace);
        PortablePreconditions.checkNotNull((String)"beanName", (Object)beanName);
        return (T)this.workspaces.get(workspace).getIfPresent((Object)beanName);
    }

    public <T> void putBean(Workspace workspace, String beanName, T instance) {
        try {
            PortablePreconditions.checkNotNull((String)"beanName", (Object)beanName);
            this.workspaces.get(workspace).get((Object)beanName, () -> instance);
        }
        catch (ExecutionException e) {
            this.logger.error("An error ocurred trying to store bean <<{}>>", (Object)instance.getClass().getSimpleName(), (Object)e);
        }
    }

    public void delete(Workspace workspace) {
        this.workspaces.remove(workspace);
    }

    public int getWorkspaceCount() {
        return this.workspaces.size();
    }

    public long getBeansCount(Workspace workspace) {
        return this.workspaces.get(workspace).size();
    }
}

