/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

public class GetRef {
    private final Repository repo;
    private final String name;

    public GetRef(Repository repo, String name) {
        this.repo = repo;
        this.name = name;
    }

    public Ref execute() {
        try {
            ObjectLoader loader;
            Ref value = this.repo.getRefDatabase().getRef(this.name);
            if (value != null) {
                return value;
            }
            ObjectId treeRef = this.repo.resolve(this.name + "^{tree}");
            if (treeRef != null && (loader = this.repo.getObjectDatabase().newReader().open((AnyObjectId)treeRef)).getType() == 2) {
                return new ObjectIdRef.PeeledTag(Ref.Storage.NEW, this.name, ObjectId.fromString((String)this.name), treeRef);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

