/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.menu;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import org.gwtbootstrap3.client.ui.AnchorButton;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.DropDownHeader;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.ListDropDown;
import org.gwtbootstrap3.client.ui.constants.Toggle;
import org.gwtbootstrap3.client.ui.html.Text;
import org.uberfire.client.views.pfly.menu.WorkbenchMenuNavBarView;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.menu.MenuPosition;

@ApplicationScoped
public class WorkbenchMenuCompactNavBarView
extends WorkbenchMenuNavBarView {
    private final Map<String, String> menuLabelMap = Maps.newHashMap();
    private final SetMultimap<String, ComplexPanel> menuItemContextMenus = HashMultimap.create();
    private final AnchorButton anchor = (AnchorButton)GWT.create(AnchorButton.class);
    private final Text text = (Text)GWT.create(Text.class);
    private final DropDownMenu dropDownMenu = (DropDownMenu)GWT.create(DropDownMenu.class);
    private final ListDropDown listDropDown = (ListDropDown)GWT.create(ListDropDown.class);

    @Override
    @PostConstruct
    protected void setup() {
        super.setup();
        this.addStyleName("uf-navbar-nav-compact");
        this.anchor.setDataToggle(Toggle.DROPDOWN);
        this.anchor.add((Widget)this.text);
        this.listDropDown.add((Widget)this.anchor);
        this.listDropDown.add((Widget)this.dropDownMenu);
        this.navbarNav.add((Widget)this.listDropDown);
    }

    @Override
    public void addMenuItem(String id, String label, String parentId, final Command command, MenuPosition position) {
        AnchorListItem menuItem = (AnchorListItem)GWT.create(AnchorListItem.class);
        menuItem.setText(label);
        if (command != null) {
            menuItem.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    command.execute();
                }
            });
        }
        this.getMenuItemWidgetMap().put(id, (ComplexPanel)menuItem);
        this.menuLabelMap.put(id, label);
        this.dropDownMenu.add((Widget)menuItem);
    }

    @Override
    public void addCustomMenuItem(Widget menu, MenuPosition position) {
    }

    @Override
    public void addGroupMenuItem(String id, String label, MenuPosition position) {
        DropDownHeader group = (DropDownHeader)GWT.create(DropDownHeader.class);
        group.setText(label);
        this.dropDownMenu.add((Widget)group);
    }

    @Override
    public void addContextMenuItem(String menuItemId, String id, String label, String parentId, final Command command, MenuPosition position) {
        ComplexPanel contextContainer;
        AnchorListItem menuItem = (AnchorListItem)GWT.create(AnchorListItem.class);
        menuItem.setText(label);
        if (parentId == null) {
            menuItem.addStyleName("uf-perspective-context-menu");
        }
        if (command != null) {
            menuItem.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    command.execute();
                }
            });
        }
        if ((contextContainer = this.getMenuItemContextWidgetMap().get(parentId)) != null) {
            contextContainer.add((Widget)menuItem);
        } else {
            this.menuItemContextMenus.get((Object)menuItemId).add(menuItem);
        }
        this.getMenuItemContextWidgetMap().put(id, (ComplexPanel)menuItem);
    }

    @Override
    public void addContextGroupMenuItem(String menuItemId, String id, String label, MenuPosition position) {
        ListDropDown listDropDown = (ListDropDown)GWT.create(ListDropDown.class);
        listDropDown.addStyleName("uf-perspective-context-menu");
        AnchorButton anchor = (AnchorButton)GWT.create(AnchorButton.class);
        anchor.setDataToggle(Toggle.DROPDOWN);
        anchor.setText(label);
        DropDownMenu dropDownMenu = (DropDownMenu)GWT.create(DropDownMenu.class);
        listDropDown.add((Widget)anchor);
        listDropDown.add((Widget)dropDownMenu);
        this.menuItemContextMenus.get((Object)menuItemId).add(listDropDown);
        this.getMenuItemContextWidgetMap().put(id, (ComplexPanel)dropDownMenu);
    }

    @Override
    public void clearContextMenu() {
        super.clearContextMenu();
        for (ComplexPanel contextContainer : this.menuItemContextMenus.values()) {
            contextContainer.clear();
            contextContainer.removeFromParent();
        }
        this.menuItemContextMenus.clear();
    }

    @Override
    public void selectMenuItem(String id) {
        super.selectMenuItem(id);
        String menuLabel = this.menuLabelMap.get(id);
        this.text.setText(menuLabel == null ? "" : menuLabel);
        for (ComplexPanel context : this.menuItemContextMenus.get((Object)id)) {
            this.navbarNav.add((Widget)context);
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.menuLabelMap.clear();
        this.menuItemContextMenus.clear();
        this.navbarNav.add((Widget)this.listDropDown);
    }

    @Override
    protected void selectElement(ComplexPanel item) {
        for (Widget widget : this.dropDownMenu) {
            widget.removeStyleName("active");
        }
        if (item != null) {
            item.addStyleName("active");
        }
    }

    protected Multimap<String, ComplexPanel> getMenuItemContextMenus() {
        return this.menuItemContextMenus;
    }
}

