/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.tab;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.BeforeSelectionEvent;
import com.google.gwt.event.logical.shared.BeforeSelectionHandler;
import com.google.gwt.event.logical.shared.HasBeforeSelectionHandlers;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.ResizeComposite;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.shared.event.TabShowEvent;
import org.gwtbootstrap3.client.shared.event.TabShowHandler;
import org.gwtbootstrap3.client.shared.event.TabShownEvent;
import org.gwtbootstrap3.client.shared.event.TabShownHandler;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.resources.WorkbenchResources;
import org.uberfire.client.views.pfly.tab.Resize;
import org.uberfire.client.views.pfly.tab.ResizeTabPanel;
import org.uberfire.client.views.pfly.tab.TabPanelEntry;
import org.uberfire.client.views.pfly.tab.TabPanelWithDropdowns;
import org.uberfire.client.workbench.panels.MultiPartWidget;
import org.uberfire.client.workbench.panels.WorkbenchPanelPresenter;
import org.uberfire.client.workbench.part.WorkbenchPartPresenter;
import org.uberfire.client.workbench.widgets.dnd.WorkbenchDragAndDropManager;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.PartDefinition;

@Dependent
public class UberTabPanel
extends ResizeComposite
implements MultiPartWidget,
ClickHandler {
    private static final int MARGIN = 20;
    final List<WorkbenchPartPresenter> parts = new ArrayList<WorkbenchPartPresenter>();
    final Map<WorkbenchPartPresenter.View, TabPanelEntry> tabIndex = new HashMap<WorkbenchPartPresenter.View, TabPanelEntry>();
    final Map<TabPanelEntry, WorkbenchPartPresenter.View> tabInvertedIndex = new HashMap<TabPanelEntry, WorkbenchPartPresenter.View>();
    final Map<PartDefinition, TabPanelEntry> partTabIndex = new HashMap<PartDefinition, TabPanelEntry>();
    private final List<Command> focusGainedHandlers = new ArrayList<Command>();
    WorkbenchDragAndDropManager dndManager;
    private ResizeTabPanel tabPanel;
    private TabPanelWithDropdowns.DropDownTab dropdownTab;
    private boolean updating;
    private boolean hasFocus = false;
    private PlaceManager panelManager;

    @Inject
    public UberTabPanel(PlaceManager panelManager, @Resize ResizeTabPanel tabPanel) {
        this.panelManager = (PlaceManager)PortablePreconditions.checkNotNull((String)"panelManager", (Object)panelManager);
        this.tabPanel = (ResizeTabPanel)((Object)PortablePreconditions.checkNotNull((String)"tabPanel", (Object)((Object)tabPanel)));
    }

    @PostConstruct
    public void init() {
        this.dropdownTab = this.tabPanel.addDropdownTab("More...");
        this.tabPanel.addShowHandler(new TabShowHandler(){

            public void onShow(TabShowEvent e) {
                if (e.getTab() != null) {
                    TabPanelEntry selected = UberTabPanel.this.tabPanel.findEntryForTabWidget(e.getTab());
                    BeforeSelectionEvent.fire((HasBeforeSelectionHandlers)UberTabPanel.this, (Object)UberTabPanel.this.tabInvertedIndex.get(selected).getPresenter().getDefinition());
                }
            }
        });
        this.tabPanel.addShownHandler(new TabShownHandler(){

            public void onShown(TabShownEvent e) {
                UberTabPanel.this.onResize();
                if (e.getTab() != null) {
                    TabPanelEntry selected = UberTabPanel.this.tabPanel.findEntryForTabWidget(e.getTab());
                    SelectionEvent.fire((HasSelectionHandlers)UberTabPanel.this, (Object)UberTabPanel.this.tabInvertedIndex.get(selected).getPresenter().getDefinition());
                }
            }
        });
        this.tabPanel.addDomHandler((EventHandler)this, ClickEvent.getType());
        this.initWidget((Widget)this.tabPanel);
    }

    public void clear() {
        this.parts.clear();
        this.tabPanel.clear();
        this.dropdownTab.clear();
        this.partTabIndex.clear();
        this.tabIndex.clear();
        this.tabInvertedIndex.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDisplayedTabs() {
        if (this.updating) {
            return;
        }
        try {
            this.updating = true;
            this.tabPanel.clear();
            this.dropdownTab.clear();
            if (this.parts.size() == 0) {
                return;
            }
            int availableSpace = this.tabPanel.getOffsetWidth();
            TabPanelEntry selectedTab = null;
            int regularTabCount = 0;
            for (int i = 0; i < this.parts.size(); ++i) {
                WorkbenchPartPresenter part = this.parts.get(i);
                TabPanelEntry tabPanelEntry = this.partTabIndex.get(part.getDefinition());
                if (tabPanelEntry.isActive()) {
                    selectedTab = tabPanelEntry;
                }
                tabPanelEntry.setActive(false);
                this.tabPanel.addItem(tabPanelEntry);
                ++regularTabCount;
                availableSpace -= tabPanelEntry.getTabWidget().getOffsetWidth();
            }
            if (selectedTab == null) {
                TabPanelEntry firstTab;
                selectedTab = firstTab = this.getTab(0);
            }
            if (availableSpace < 0) {
                LinkedList<TabPanelEntry> newDropdownContents = new LinkedList<TabPanelEntry>();
                this.dropdownTab.setText("More...");
                this.tabPanel.addDropdownTab(this.dropdownTab);
                while (availableSpace - this.dropdownTab.getTabWidth() < 0 && regularTabCount > 1) {
                    TabPanelEntry tab = this.getTab(--regularTabCount);
                    availableSpace += tab.getTabWidget().getOffsetWidth();
                    this.tabPanel.remove(tab);
                    newDropdownContents.addFirst(tab);
                    if (tab != selectedTab) continue;
                    this.dropdownTab.setText(selectedTab.getTitle());
                }
                for (TabPanelEntry l : newDropdownContents) {
                    this.dropdownTab.addItem(l);
                }
            }
            selectedTab.showTab();
        }
        finally {
            this.updating = false;
        }
    }

    private TabPanelEntry getTab(int i) {
        return (TabPanelEntry)PortablePreconditions.checkNotNull((String)"part entry in map", (Object)this.partTabIndex.get(this.parts.get(i).getDefinition()));
    }

    public boolean selectPart(PartDefinition id) {
        TabPanelEntry tab = this.partTabIndex.get(id);
        if (tab != null) {
            tab.showTab();
        }
        return false;
    }

    public boolean remove(PartDefinition id) {
        TabPanelEntry tab = this.partTabIndex.get(id);
        if (tab == null) {
            return false;
        }
        boolean wasActive = tab.isActive();
        WorkbenchPartPresenter.View partView = this.tabInvertedIndex.remove(tab);
        int removedTabIndex = this.parts.indexOf(partView.getPresenter());
        this.parts.remove(removedTabIndex);
        this.tabIndex.remove(partView);
        this.partTabIndex.remove(id);
        this.updateDisplayedTabs();
        if (removedTabIndex >= 0 && wasActive && this.parts.size() > 0) {
            this.selectPart(this.parts.get(removedTabIndex <= 0 ? 0 : removedTabIndex - 1).getDefinition());
        }
        return true;
    }

    public void changeTitle(PartDefinition id, String title, IsWidget titleDecoration) {
        TabPanelEntry tab = this.partTabIndex.get(id);
        if (tab != null) {
            tab.setTitle(title);
        }
    }

    public HandlerRegistration addBeforeSelectionHandler(BeforeSelectionHandler<PartDefinition> handler) {
        return this.addHandler((EventHandler)handler, BeforeSelectionEvent.getType());
    }

    public HandlerRegistration addSelectionHandler(SelectionHandler<PartDefinition> handler) {
        return this.addHandler((EventHandler)handler, SelectionEvent.getType());
    }

    public void setPresenter(WorkbenchPanelPresenter presenter) {
    }

    public void addPart(WorkbenchPartPresenter.View view) {
        if (!this.tabIndex.containsKey(view)) {
            TabPanelEntry tab = this.tabPanel.addItem(view.getPresenter().getTitle(), view.asWidget());
            this.resizeIfNeeded(view.asWidget());
            this.tabIndex.put(view, tab);
            this.tabInvertedIndex.put(tab, view);
            this.partTabIndex.put(view.getPresenter().getDefinition(), tab);
            this.dndManager.makeDraggable((IsWidget)view, (IsWidget)tab.getTabWidget());
            this.addCloseToTab(tab);
            this.parts.add(view.getPresenter());
            this.tabIndex.put(view, tab);
            this.updateDisplayedTabs();
        }
    }

    private void resizeIfNeeded(Widget widget) {
        if (this.isAttached() && widget instanceof RequiresResize) {
            ((RequiresResize)widget).onResize();
        }
    }

    public void onResize() {
        this.updateDisplayedTabs();
        this.tabPanel.onResize();
    }

    private void addCloseToTab(final TabPanelEntry tab) {
        Button close = new Button("&times;");
        close.setStyleName("close");
        close.addStyleName(WorkbenchResources.INSTANCE.CSS().tabCloseButton());
        close.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                WorkbenchPartPresenter.View partToDeselect = UberTabPanel.this.tabInvertedIndex.get(tab);
                UberTabPanel.this.panelManager.closePlace(partToDeselect.getPresenter().getDefinition().getPlace());
            }
        });
        tab.getTabWidget().addToAnchor((Widget)close);
    }

    public void setDndManager(WorkbenchDragAndDropManager dndManager) {
        this.dndManager = dndManager;
    }

    public void setFocus(boolean hasFocus) {
        this.hasFocus = hasFocus;
        this.tabPanel.setFocus(hasFocus);
    }

    public void onClick(ClickEvent event) {
        if (!this.hasFocus) {
            this.fireFocusGained();
            WorkbenchPartPresenter.View view = this.getSelectedPart();
            if (view != null) {
                SelectionEvent.fire((HasSelectionHandlers)this, (Object)view.getPresenter().getDefinition());
            }
        }
    }

    private WorkbenchPartPresenter.View getSelectedPart() {
        return this.tabInvertedIndex.get(this.tabPanel.getActiveTab());
    }

    private void fireFocusGained() {
        for (int i = this.focusGainedHandlers.size() - 1; i >= 0; --i) {
            this.focusGainedHandlers.get(i).execute();
        }
    }

    public void addOnFocusHandler(Command doWhenFocused) {
        this.focusGainedHandlers.add((Command)PortablePreconditions.checkNotNull((String)"doWhenFocused", (Object)doWhenFocused));
    }

    public int getPartsSize() {
        return this.partTabIndex.size();
    }

    public Collection<PartDefinition> getParts() {
        return Collections.unmodifiableSet(this.partTabIndex.keySet());
    }
}

