/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.client.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.SendAcknowledgementHandler;
import org.apache.activemq.artemis.core.client.ActiveMQClientMessageBundle;
import org.apache.activemq.artemis.core.client.impl.ClientProducerCredits;
import org.apache.activemq.artemis.core.client.impl.ClientProducerInternal;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.core.message.LargeBodyEncoder;
import org.apache.activemq.artemis.spi.core.remoting.SessionContext;
import org.apache.activemq.artemis.utils.ActiveMQBufferInputStream;
import org.apache.activemq.artemis.utils.DeflaterReader;
import org.apache.activemq.artemis.utils.TokenBucketLimiter;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.jboss.logging.Logger;

public class ClientProducerImpl
implements ClientProducerInternal {
    private static final Logger logger = Logger.getLogger(ClientProducerImpl.class);
    private final SimpleString address;
    private final ClientSessionInternal session;
    private final SessionContext sessionContext;
    private volatile boolean closed;
    private final TokenBucketLimiter rateLimiter;
    private final boolean blockOnNonDurableSend;
    private final boolean blockOnDurableSend;
    private final SimpleString groupID;
    private final int minLargeMessageSize;
    private final ClientProducerCredits producerCredits;

    public ClientProducerImpl(ClientSessionInternal session, SimpleString address, TokenBucketLimiter rateLimiter, boolean blockOnNonDurableSend, boolean blockOnDurableSend, boolean autoGroup, SimpleString groupID, int minLargeMessageSize, SessionContext sessionContext) {
        this.sessionContext = sessionContext;
        this.session = session;
        this.address = address;
        this.rateLimiter = rateLimiter;
        this.blockOnNonDurableSend = blockOnNonDurableSend;
        this.blockOnDurableSend = blockOnDurableSend;
        this.groupID = autoGroup ? UUIDGenerator.getInstance().generateSimpleStringUUID() : groupID;
        this.minLargeMessageSize = minLargeMessageSize;
        this.producerCredits = address != null ? session.getCredits(address, false) : null;
    }

    @Override
    public SimpleString getAddress() {
        return this.address;
    }

    @Override
    public void send(Message msg) throws ActiveMQException {
        this.checkClosed();
        this.doSend(null, msg, null, false);
    }

    @Override
    public void send(SimpleString address1, Message msg) throws ActiveMQException {
        this.checkClosed();
        this.doSend(address1, msg, null, false);
    }

    @Override
    public void send(String address1, Message message) throws ActiveMQException {
        this.send(SimpleString.toSimpleString((String)address1), message);
    }

    @Override
    public void send(SimpleString address1, Message message, SendAcknowledgementHandler handler) throws ActiveMQException {
        this.checkClosed();
        boolean confirmationWindowEnabled = this.session.isConfirmationWindowEnabled();
        if (confirmationWindowEnabled) {
            this.doSend(address1, message, handler, true);
        } else {
            this.doSend(address1, message, null, true);
            if (handler != null) {
                this.session.scheduleConfirmation(handler, message);
            }
        }
    }

    @Override
    public void send(Message message, SendAcknowledgementHandler handler) throws ActiveMQException {
        this.send(null, message, handler);
    }

    @Override
    public synchronized void close() throws ActiveMQException {
        if (this.closed) {
            return;
        }
        this.doCleanup();
    }

    @Override
    public void cleanUp() {
        if (this.closed) {
            return;
        }
        this.doCleanup();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isBlockOnDurableSend() {
        return this.blockOnDurableSend;
    }

    @Override
    public boolean isBlockOnNonDurableSend() {
        return this.blockOnNonDurableSend;
    }

    @Override
    public int getMaxRate() {
        return this.rateLimiter == null ? -1 : this.rateLimiter.getRate();
    }

    @Override
    public ClientProducerCredits getProducerCredits() {
        return this.producerCredits;
    }

    private void doCleanup() {
        if (this.address != null) {
            this.session.returnCredits(this.address);
        }
        this.session.removeProducer(this);
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSend(SimpleString sendingAddress, Message msgToSend, SendAcknowledgementHandler handler, boolean forceAsync) throws ActiveMQException {
        if (sendingAddress == null) {
            sendingAddress = this.address;
        }
        this.session.startCall();
        try {
            ICoreMessage msg = msgToSend.toCore();
            boolean isLarge = this.sessionContext.supportsLargeMessage() && (this.getBodyInputStream(msg) != null || msg.isLargeMessage() || msg.getBodyBuffer().writerIndex() > this.minLargeMessageSize);
            if (!isLarge) {
                this.session.setAddress(msg, sendingAddress);
            } else {
                msg.setAddress(sendingAddress);
            }
            ClientProducerCredits theCredits = this.session.getCredits(sendingAddress, true);
            if (this.rateLimiter != null) {
                this.rateLimiter.limit();
            }
            if (this.groupID != null) {
                msg.putStringProperty(Message.HDR_GROUP_ID, this.groupID);
            }
            boolean sendBlockingConfig = msg.isDurable() ? this.blockOnDurableSend : this.blockOnNonDurableSend;
            boolean forceAsyncOverride = handler != null;
            boolean sendBlocking = sendBlockingConfig && !forceAsyncOverride;
            this.session.workDone();
            if (isLarge) {
                this.largeMessageSend(sendBlocking, msg, theCredits, handler);
            } else {
                this.sendRegularMessage(sendingAddress, msg, sendBlocking, theCredits, handler);
            }
        }
        finally {
            this.session.endCall();
        }
    }

    private InputStream getBodyInputStream(ICoreMessage msgI) {
        return msgI.getBodyInputStream();
    }

    private void sendRegularMessage(SimpleString sendingAddress, ICoreMessage msgI, boolean sendBlocking, ClientProducerCredits theCredits, SendAcknowledgementHandler handler) throws ActiveMQException {
        logger.tracef("sendRegularMessage::%s, Blocking=%s", (Object)msgI, (Object)sendBlocking);
        int creditSize = this.sessionContext.getCreditsOnSendingFull(msgI);
        theCredits.acquireCredits(creditSize);
        this.sessionContext.sendFullMessage(msgI, sendBlocking, handler, this.address);
    }

    private void checkClosed() throws ActiveMQException {
        if (this.closed) {
            throw ActiveMQClientMessageBundle.BUNDLE.producerClosed();
        }
    }

    private void largeMessageSend(boolean sendBlocking, ICoreMessage msgI, ClientProducerCredits credits, SendAcknowledgementHandler handler) throws ActiveMQException {
        logger.tracef("largeMessageSend::%s, Blocking=%s", (Object)msgI, (Object)sendBlocking);
        int headerSize = msgI.getHeadersAndPropertiesEncodeSize();
        if (msgI.getHeadersAndPropertiesEncodeSize() >= this.minLargeMessageSize) {
            throw ActiveMQClientMessageBundle.BUNDLE.headerSizeTooBig(headerSize);
        }
        if (this.getBodyInputStream(msgI) == null && msgI.getBuffer() != null) {
            msgI.getBuffer().readerIndex(0);
        }
        if (msgI.isServerMessage()) {
            this.largeMessageSendServer(sendBlocking, msgI, credits, handler);
        } else {
            InputStream input = this.getBodyInputStream(msgI);
            if (input != null) {
                this.largeMessageSendStreamed(sendBlocking, msgI, input, credits, handler);
            } else {
                this.largeMessageSendBuffered(sendBlocking, msgI, credits, handler);
            }
        }
    }

    private void sendInitialLargeMessageHeader(Message msgI, ClientProducerCredits credits) throws ActiveMQException {
        int creditsUsed = this.sessionContext.sendInitialChunkOnLargeMessage(msgI);
        credits.acquireCredits(creditsUsed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void largeMessageSendServer(boolean sendBlocking, ICoreMessage msgI, ClientProducerCredits credits, SendAcknowledgementHandler handler) throws ActiveMQException {
        this.sendInitialLargeMessageHeader(msgI, credits);
        LargeBodyEncoder context = msgI.getBodyEncoder();
        long bodySize = context.getLargeBodySize();
        context.open();
        try {
            long pos = 0L;
            while (pos < bodySize) {
                int chunkLength = (int)Math.min(bodySize - pos, (long)this.minLargeMessageSize);
                ActiveMQBuffer bodyBuffer = ActiveMQBuffers.fixedBuffer((int)chunkLength);
                context.encode(bodyBuffer, chunkLength);
                boolean lastChunk = (pos += (long)chunkLength) >= bodySize;
                SendAcknowledgementHandler messageHandler = lastChunk ? handler : null;
                int creditsUsed = this.sessionContext.sendServerLargeMessageChunk(msgI, -1L, sendBlocking, lastChunk, bodyBuffer.toByteBuffer().array(), messageHandler);
                credits.acquireCredits(creditsUsed);
            }
        }
        finally {
            context.close();
        }
    }

    private void largeMessageSendBuffered(boolean sendBlocking, ICoreMessage msgI, ClientProducerCredits credits, SendAcknowledgementHandler handler) throws ActiveMQException {
        msgI.getBodyBuffer().readerIndex(0);
        this.largeMessageSendStreamed(sendBlocking, msgI, new ActiveMQBufferInputStream(msgI.getBodyBuffer()), credits, handler);
    }

    private void largeMessageSendStreamed(boolean sendBlocking, ICoreMessage msgI, InputStream inputStreamParameter, ClientProducerCredits credits, SendAcknowledgementHandler handler) throws ActiveMQException {
        boolean lastPacket = false;
        InputStream input = inputStreamParameter;
        AtomicLong messageSize = new AtomicLong();
        DeflaterReader deflaterReader = null;
        if (this.session.isCompressLargeMessages()) {
            msgI.putBooleanProperty(Message.HDR_LARGE_COMPRESSED, true);
            deflaterReader = new DeflaterReader(inputStreamParameter, messageSize);
            input = deflaterReader;
        }
        long totalSize = 0L;
        boolean headerSent = false;
        int reconnectID = this.sessionContext.getReconnectID();
        while (!lastPacket) {
            int numberOfBytesRead;
            byte[] buff = new byte[this.minLargeMessageSize];
            int pos = 0;
            do {
                int wanted = this.minLargeMessageSize - pos;
                try {
                    numberOfBytesRead = input.read(buff, pos, wanted);
                }
                catch (IOException e) {
                    throw ActiveMQClientMessageBundle.BUNDLE.errorReadingBody(e);
                }
                if (numberOfBytesRead != -1) continue;
                lastPacket = true;
                break;
            } while ((pos += numberOfBytesRead) < this.minLargeMessageSize);
            totalSize += (long)pos;
            if (lastPacket) {
                if (!this.session.isCompressLargeMessages()) {
                    messageSize.set(totalSize);
                }
                byte[] buff2 = new byte[pos];
                System.arraycopy(buff, 0, buff2, 0, pos);
                buff = buff2;
                if (!headerSent && this.session.isCompressLargeMessages() && buff2.length < this.minLargeMessageSize) {
                    msgI.getBodyBuffer().resetReaderIndex();
                    msgI.getBodyBuffer().resetWriterIndex();
                    msgI.putLongProperty(Message.HDR_LARGE_BODY_SIZE, deflaterReader.getTotalSize());
                    msgI.getBodyBuffer().writeBytes(buff, 0, pos);
                    this.sendRegularMessage(msgI.getAddressSimpleString(), msgI, sendBlocking, credits, handler);
                    return;
                }
                if (!headerSent) {
                    headerSent = true;
                    this.sendInitialLargeMessageHeader(msgI, credits);
                }
                int creditsSent = this.sessionContext.sendLargeMessageChunk(msgI, messageSize.get(), sendBlocking, true, buff, reconnectID, handler);
                credits.acquireCredits(creditsSent);
                continue;
            }
            if (!headerSent) {
                headerSent = true;
                this.sendInitialLargeMessageHeader(msgI, credits);
            }
            int creditsSent = this.sessionContext.sendLargeMessageChunk(msgI, messageSize.get(), sendBlocking, false, buff, reconnectID, handler);
            credits.acquireCredits(creditsSent);
        }
        try {
            input.close();
        }
        catch (IOException e) {
            throw ActiveMQClientMessageBundle.BUNDLE.errorClosingLargeMessage(e);
        }
    }
}

