/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl.netty;

import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.utils.Env;

public final class Epoll {
    private static final boolean IS_EPOLL_AVAILABLE = Epoll.isEpollAvailable();

    private static boolean isEpollAvailable() {
        try {
            if (Env.is64BitJvm() && Env.isLinuxOs()) {
                return io.netty.channel.epoll.Epoll.isAvailable();
            }
            return false;
        }
        catch (Throwable e) {
            ActiveMQClientLogger.LOGGER.unableToCheckEpollAvailability(e);
            return false;
        }
    }

    private Epoll() {
    }

    public static boolean isAvailable() {
        return IS_EPOLL_AVAILABLE;
    }
}

