/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.uberfire.java.nio.fs.jgit.util.Git;

public class ResolveObjectIds {
    private final Git git;
    private final String[] ids;

    public ResolveObjectIds(Git git, String ... ids) {
        this.git = git;
        this.ids = ids;
    }

    public List<ObjectId> execute() {
        ArrayList<ObjectId> result = new ArrayList<ObjectId>();
        for (String id : this.ids) {
            try {
                Ref refName = this.git.getRef(id);
                if (refName != null) {
                    result.add(refName.getObjectId());
                    continue;
                }
                try {
                    ObjectId _id = ObjectId.fromString((String)id);
                    if (!this.git.getRepository().getObjectDatabase().has((AnyObjectId)_id)) continue;
                    result.add(_id);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }
}

