/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.jsbridge.client.screen;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.user.client.ui.IsWidget;
import elemental2.dom.HTMLElement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jboss.errai.bus.client.ErraiBus;
import org.jboss.errai.bus.client.api.Subscription;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.jboss.errai.enterprise.client.cdi.AbstractCDIEventCallback;
import org.jboss.errai.enterprise.client.cdi.api.CDI;
import org.jboss.errai.marshalling.client.Marshalling;
import org.uberfire.client.mvp.AbstractWorkbenchScreenActivity;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.jsbridge.JsWorkbenchLazyActivity;
import org.uberfire.jsbridge.client.JsPlaceRequest;
import org.uberfire.jsbridge.client.screen.InvocationPostponer;
import org.uberfire.jsbridge.client.screen.JsNativeScreen;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.Position;
import org.uberfire.workbench.model.menu.Menus;
import org.uberfire.workbench.model.toolbar.ToolBar;

public class JsWorkbenchScreenActivity
extends AbstractWorkbenchScreenActivity
implements JsWorkbenchLazyActivity {
    private InvocationPostponer invocationsPostponer;
    private PlaceRequest place;
    private JsNativeScreen screen;
    List<Subscription> subscriptions;

    public JsWorkbenchScreenActivity(JsNativeScreen screen, PlaceManager placeManager) {
        super(placeManager);
        this.screen = screen;
        this.subscriptions = new ArrayList<Subscription>();
        this.invocationsPostponer = new InvocationPostponer();
    }

    public void updateRealContent(JavaScriptObject jsObject) {
        this.screen.updateRealContent(jsObject);
        this.invocationsPostponer.executeAll();
    }

    public void onStartup(PlaceRequest place) {
        this.place = place;
        if (!this.isScreenLoaded()) {
            this.invocationsPostponer.postpone(() -> this.onStartup(place));
            return;
        }
        this.registerSubscriptions();
        this.screen.onStartup(JsPlaceRequest.fromPlaceRequest(place));
    }

    public boolean isScreenLoaded() {
        return this.screen.screenLoaded();
    }

    public void onOpen() {
        this.screen.render();
        if (!this.isScreenLoaded()) {
            this.invocationsPostponer.postpone(this::onOpen);
            return;
        }
        this.screen.onOpen();
        this.placeManager.executeOnOpenCallbacks(this.place);
    }

    public void onClose() {
        if (this.isScreenLoaded()) {
            this.screen.onClose();
        }
        this.placeManager.executeOnCloseCallbacks(this.place);
    }

    public boolean onMayClose() {
        if (this.isScreenLoaded()) {
            return this.screen.onMayClose();
        }
        return true;
    }

    public void onShutdown() {
        this.invocationsPostponer.clear();
        if (this.isScreenLoaded()) {
            this.unsubscribeFromAllEvents();
            this.screen.onShutdown();
        }
    }

    public void onFocus() {
        if (this.isScreenLoaded()) {
            this.screen.onFocus();
        }
    }

    public void onLostFocus() {
        if (this.isScreenLoaded()) {
            this.screen.onLostFocus();
        }
    }

    public String getTitle() {
        return this.screen.componentTitle();
    }

    public Position getDefaultPosition() {
        return CompassPosition.ROOT;
    }

    public PlaceRequest getPlace() {
        return this.place;
    }

    public String getIdentifier() {
        return this.screen.getComponentId();
    }

    public IsWidget getTitleDecoration() {
        return null;
    }

    public void getMenus(Consumer<Menus> consumer) {
        consumer.accept(null);
    }

    public ToolBar getToolBar() {
        return null;
    }

    public PlaceRequest getOwningPlace() {
        return null;
    }

    public IsWidget getWidget() {
        return ElementWrapperWidget.getWidget((HTMLElement)this.screen.getElement());
    }

    public String contextId() {
        return this.screen.componentContextId();
    }

    public int preferredHeight() {
        return -1;
    }

    public int preferredWidth() {
        return -1;
    }

    void registerSubscriptions() {
        this.screen.subscriptions().forEach(this::registerSubscription);
    }

    Void registerSubscription(Object callback, String eventFqcn, Object obj) {
        this.subscriptions.add(this.getSubscription(callback, eventFqcn));
        this.subscribeOnErraiBus(eventFqcn);
        return null;
    }

    void subscribeOnErraiBus(String eventFqcn) {
        ErraiBus.get().subscribe("cdi.event:" + eventFqcn, CDI.ROUTING_CALLBACK);
    }

    Subscription getSubscription(final Object callback, String eventFqcn) {
        return CDI.subscribe((String)eventFqcn, (AbstractCDIEventCallback)new AbstractCDIEventCallback<Object>(){

            public void fireEvent(Object event) {
                JsWorkbenchScreenActivity.this.callWithParsedJsonObject(callback, Marshalling.toJSON((Object)event));
            }
        });
    }

    public native void callWithParsedJsonObject(Object var1, String var2);

    private void unsubscribeFromAllEvents() {
        this.subscriptions.forEach(Subscription::remove);
        this.subscriptions = new ArrayList<Subscription>();
    }
}

