/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.impl.authz;

import java.util.HashSet;
import java.util.Set;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.security.authz.AuthorizationPolicy;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionCollection;
import org.uberfire.security.impl.authz.DefaultAuthorizationEntry;

@Portable
public class DefaultAuthorizationPolicy
implements AuthorizationPolicy {
    DefaultAuthorizationEntry defaultEntry = new DefaultAuthorizationEntry();
    private Set<DefaultAuthorizationEntry> entrySet = new HashSet<DefaultAuthorizationEntry>();

    protected DefaultAuthorizationEntry registerAuthzEntry(DefaultAuthorizationEntry entry) {
        this.entrySet.add(entry);
        return entry;
    }

    protected DefaultAuthorizationEntry getAuthzEntry(Role role) {
        for (DefaultAuthorizationEntry entry : this.entrySet) {
            if (entry.getRole() == null || !entry.getRole().equals(role)) continue;
            return entry;
        }
        DefaultAuthorizationEntry entry = new DefaultAuthorizationEntry(role);
        entry.setRole(role);
        return this.registerAuthzEntry(entry);
    }

    protected DefaultAuthorizationEntry getAuthzEntry(Group group) {
        for (DefaultAuthorizationEntry entry : this.entrySet) {
            if (entry.getGroup() == null || !entry.getGroup().equals(group)) continue;
            return entry;
        }
        DefaultAuthorizationEntry entry = new DefaultAuthorizationEntry(group);
        entry.setGroup(group);
        return this.registerAuthzEntry(entry);
    }

    @Override
    public Set<Role> getRoles() {
        HashSet<Role> result = new HashSet<Role>();
        for (DefaultAuthorizationEntry entry : this.entrySet) {
            if (entry.getRole() == null) continue;
            result.add(entry.getRole());
        }
        return result;
    }

    @Override
    public Set<Group> getGroups() {
        HashSet<Group> result = new HashSet<Group>();
        for (DefaultAuthorizationEntry entry : this.entrySet) {
            if (entry.getGroup() == null) continue;
            result.add(entry.getGroup());
        }
        return result;
    }

    @Override
    public String getRoleDescription(Role role) {
        DefaultAuthorizationEntry entry = this.getAuthzEntry(role);
        return entry.getDescription();
    }

    @Override
    public void setRoleDescription(Role role, String description) {
        DefaultAuthorizationEntry entry = this.getAuthzEntry(role);
        entry.setDescription(description);
    }

    @Override
    public String getGroupDescription(Group group) {
        DefaultAuthorizationEntry entry = this.getAuthzEntry(group);
        return entry.getDescription();
    }

    @Override
    public void setGroupDescription(Group group, String description) {
        DefaultAuthorizationEntry entry = this.getAuthzEntry(group);
        entry.setDescription(description);
    }

    @Override
    public int getPriority(Role role) {
        DefaultAuthorizationEntry entry = this.getAuthzEntry(role);
        Integer priority = entry.getPriority();
        return priority != null ? priority : this.defaultEntry.getPriority();
    }

    @Override
    public int getPriority(Group group) {
        DefaultAuthorizationEntry entry = this.getAuthzEntry(group);
        Integer priority = entry.getPriority();
        return priority != null ? priority : this.defaultEntry.getPriority();
    }

    @Override
    public void setPriority(Role role, int priority) {
        DefaultAuthorizationEntry entry = this.getAuthzEntry(role);
        entry.setPriority(priority);
    }

    @Override
    public void setPriority(Group group, int priority) {
        DefaultAuthorizationEntry entry = this.getAuthzEntry(group);
        entry.setPriority(priority);
    }

    @Override
    public PermissionCollection getPermissions(Role role) {
        DefaultAuthorizationEntry entry = this.getAuthzEntry(role);
        return entry.getPermissions().merge(this.defaultEntry.getPermissions(), -1);
    }

    @Override
    public PermissionCollection getPermissions(Group group) {
        DefaultAuthorizationEntry entry = this.getAuthzEntry(group);
        return entry.getPermissions().merge(this.defaultEntry.getPermissions(), -1);
    }

    public void addPermission(Permission permission) {
        this.defaultEntry.getPermissions().add(permission);
    }

    public void addPermission(Role role, Permission permission) {
        DefaultAuthorizationEntry entry = this.getAuthzEntry(role);
        entry.getPermissions().add(permission);
    }

    public void addPermission(Group group, Permission permission) {
        DefaultAuthorizationEntry entry = this.getAuthzEntry(group);
        entry.getPermissions().add(permission);
    }

    @Override
    public void setPermissions(Role role, PermissionCollection collection) {
        DefaultAuthorizationEntry entry = this.getAuthzEntry(role);
        entry.setPermissions(collection);
    }

    @Override
    public void setPermissions(Group group, PermissionCollection collection) {
        DefaultAuthorizationEntry entry = this.getAuthzEntry(group);
        entry.setPermissions(collection);
    }

    @Override
    public void setHomePerspective(Role role, String perspective) {
        DefaultAuthorizationEntry entry = this.getAuthzEntry(role);
        entry.setHomePerspective(perspective);
    }

    @Override
    public void setHomePerspective(Group group, String perspective) {
        DefaultAuthorizationEntry entry = this.getAuthzEntry(group);
        entry.setHomePerspective(perspective);
    }

    @Override
    public String getHomePerspective(Role role) {
        DefaultAuthorizationEntry entry = this.getAuthzEntry(role);
        String home = entry.getHomePerspective();
        return home != null ? home : this.defaultEntry.getHomePerspective();
    }

    @Override
    public String getHomePerspective(Group group) {
        DefaultAuthorizationEntry entry = this.getAuthzEntry(group);
        String home = entry.getHomePerspective();
        return home != null ? home : this.defaultEntry.getHomePerspective();
    }

    @Override
    public String getHomePerspective(User user) {
        int priority;
        String home;
        String lastHome = this.getHomePerspective();
        int lastPriority = Integer.MIN_VALUE;
        if (user.getRoles() != null) {
            for (Role role : user.getRoles()) {
                home = this.getHomePerspective(role);
                if (home == null) continue;
                priority = this.getPriority(role);
                if (lastHome != null && priority <= lastPriority) continue;
                lastHome = home;
                lastPriority = priority;
            }
        }
        if (user.getGroups() != null) {
            for (Group group : user.getGroups()) {
                home = this.getHomePerspective(group);
                if (home == null) continue;
                priority = this.getPriority(group);
                if (lastHome != null && priority <= lastPriority) continue;
                lastHome = home;
                lastPriority = priority;
            }
        }
        return lastHome;
    }

    @Override
    public String getHomePerspective() {
        return this.defaultEntry.getHomePerspective();
    }

    @Override
    public void setHomePerspective(String perspectiveId) {
        this.defaultEntry.setHomePerspective(perspectiveId);
    }

    @Override
    public PermissionCollection getPermissions() {
        return this.defaultEntry.getPermissions();
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        this.entrySet.forEach(e -> out.append(e.toString()).append("\n"));
        return out.toString();
    }
}

