/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.file.api;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.file.FileSystemNotFoundException;
import org.uberfire.java.nio.file.spi.FileSystemProvider;

public final class FileSystemProviders {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemProviders.class);
    private static List<FileSystemProvider> installedProviders = null;
    private static Map<String, FileSystemProvider> mapOfinstalledProviders = null;

    private static void setup() {
        try {
            installedProviders = FileSystemProviders.buildProviders();
            mapOfinstalledProviders = FileSystemProviders.buildProvidersMap();
        }
        catch (Throwable ex) {
            LOGGER.error("Can't initialize FileSystemProviders", ex);
        }
        LOGGER.debug("Initialized FileSystemProviders.\nInstalled Providers: " + installedProviders + "\nProvider Map: " + mapOfinstalledProviders);
    }

    private static synchronized List<FileSystemProvider> buildProviders() {
        ServiceLoader<FileSystemProvider> providers = ServiceLoader.load(FileSystemProvider.class);
        if (providers == null) {
            return Collections.emptyList();
        }
        ArrayList<FileSystemProvider> result = new ArrayList<FileSystemProvider>();
        for (FileSystemProvider provider : providers) {
            result.add(provider);
        }
        return Collections.unmodifiableList(result);
    }

    private static synchronized Map<String, FileSystemProvider> buildProvidersMap() {
        HashMap<String, FileSystemProvider> result = new HashMap<String, FileSystemProvider>(installedProviders.size() + 1);
        for (int i = 0; i < installedProviders.size(); ++i) {
            FileSystemProvider provider = installedProviders.get(i);
            if (i == 0) {
                provider.forceAsDefault();
                result.put("default", provider);
            }
            result.put(provider.getScheme(), provider);
        }
        return Collections.unmodifiableMap(result);
    }

    public static FileSystemProvider getDefaultProvider() throws ServiceConfigurationError {
        if (installedProviders == null) {
            FileSystemProviders.setup();
        }
        return installedProviders.get(0);
    }

    public static FileSystemProvider resolveProvider(URI uri) {
        PortablePreconditions.checkNotNull((String)"uri", (Object)uri);
        if (installedProviders == null) {
            FileSystemProviders.setup();
        }
        return FileSystemProviders.getProvider(uri.getScheme());
    }

    private static FileSystemProvider getProvider(String scheme) throws FileSystemNotFoundException, ServiceConfigurationError {
        PortablePreconditions.checkNotEmpty((String)"scheme", (String)scheme);
        FileSystemProvider fileSystemProvider = mapOfinstalledProviders.get(scheme);
        if (fileSystemProvider == null) {
            throw new FileSystemNotFoundException("Provider '" + scheme + "' not found");
        }
        return fileSystemProvider;
    }

    public static List<FileSystemProvider> installedProviders() throws ServiceConfigurationError {
        if (installedProviders == null) {
            FileSystemProviders.setup();
        }
        return installedProviders;
    }
}

