/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.core;

import java.lang.Double;
import java.lang.Object;
import java.lang.String;
import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;
import jsinterop.base.JsArrayLike;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class Array<T> implements Iterable<T>, JsArrayLike<T> {
  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface EntriesIteratorIterableTypeParameterArrayUnionType<T> {
    @JsOverlay
    static EntriesIteratorIterableTypeParameterArrayUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.castToDouble(this);
    }

    @JsOverlay
    default T asT() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }
  }

  @JsFunction
  public interface EveryCallbackFn<T> {
    Object onInvoke(T p0, double p1, T[] p2);
  }

  @JsFunction
  public interface FilterCallbackFn<T> {
    Object onInvoke(T p0, double p1, T[] p2);
  }

  @JsFunction
  public interface FindIndexPredicateCallbackFn<T> {
    boolean onInvoke(T p0, double p1, T[] p2);
  }

  @JsFunction
  public interface FindPredicateCallbackFn<T> {
    boolean onInvoke(T p0, double p1, T[] p2);
  }

  @JsFunction
  public interface ForEachCallbackFn<T> {
    Object onInvoke(T p0, double p1, T[] p2);
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface FromArrayLikeUnionType<T> {
    @JsOverlay
    static FromArrayLikeUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default Iterable<T> asIterable() {
      return Js.cast(this);
    }

    @JsOverlay
    default JsArrayLike<T> asJsArrayLike() {
      return Js.cast(this);
    }

    @JsOverlay
    default String asString() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsFunction
  public interface FromMapCallbackFn<T, R> {
    @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
    public interface P0UnionType<T> {
      @JsOverlay
      static FromMapCallbackFn.P0UnionType of(Object o) {
        return Js.cast(o);
      }

      @JsOverlay
      default String asString() {
        return Js.cast(this);
      }

      @JsOverlay
      default T asT() {
        return Js.cast(this);
      }

      @JsOverlay
      default boolean isString() {
        return (Object) this instanceof String;
      }
    }

    R onInvoke(FromMapCallbackFn.P0UnionType<T> p0, double p1);

    @JsOverlay
    default R onInvoke(String p0, double p1) {
      return onInvoke(Js.<FromMapCallbackFn.P0UnionType<T>>uncheckedCast(p0), p1);
    }

    @JsOverlay
    default R onInvoke(T p0, double p1) {
      return onInvoke(Js.<FromMapCallbackFn.P0UnionType<T>>uncheckedCast(p0), p1);
    }
  }

  @JsFunction
  public interface MapCallbackFn<T, R> {
    R onInvoke(T p0, double p1, T[] p2);
  }

  @JsFunction
  public interface ReduceCallbackFn<T, R> {
    R onInvoke(Object p0, T p1, double p2, T[] p3);
  }

  @JsFunction
  public interface ReduceRightCallbackFn<T, R> {
    R onInvoke(Object p0, T p1, double p2, T[] p3);
  }

  @JsFunction
  public interface SomeCallbackFn<T> {
    Object onInvoke(T p0, double p1, T[] p2);
  }

  @JsFunction
  public interface SortCompareFunctionCallbackFn<T> {
    double onInvoke(T p0, T p1);
  }

  public static native <T, R> R[] from(
      FromArrayLikeUnionType<T> arrayLike, FromMapCallbackFn<T, R> mapFn, Object this_);

  public static native <T, R> R[] from(
      FromArrayLikeUnionType<T> arrayLike, FromMapCallbackFn<T, R> mapFn);

  public static native <T, R> R[] from(FromArrayLikeUnionType<T> arrayLike);

  @JsOverlay
  public static final <T, R> R[] from(
      Iterable<T> arrayLike, FromMapCallbackFn<T, R> mapFn, Object this_) {
    return from(Js.<FromArrayLikeUnionType<T>>uncheckedCast(arrayLike), mapFn, this_);
  }

  @JsOverlay
  public static final <T, R> R[] from(Iterable<T> arrayLike, FromMapCallbackFn<T, R> mapFn) {
    return from(Js.<FromArrayLikeUnionType<T>>uncheckedCast(arrayLike), mapFn);
  }

  @JsOverlay
  public static final <T, R> R[] from(Iterable<T> arrayLike) {
    return from(Js.<FromArrayLikeUnionType<T>>uncheckedCast(arrayLike));
  }

  @JsOverlay
  public static final <T, R> R[] from(
      JsArrayLike<T> arrayLike, FromMapCallbackFn<T, R> mapFn, Object this_) {
    return from(Js.<FromArrayLikeUnionType<T>>uncheckedCast(arrayLike), mapFn, this_);
  }

  @JsOverlay
  public static final <T, R> R[] from(JsArrayLike<T> arrayLike, FromMapCallbackFn<T, R> mapFn) {
    return from(Js.<FromArrayLikeUnionType<T>>uncheckedCast(arrayLike), mapFn);
  }

  @JsOverlay
  public static final <T, R> R[] from(JsArrayLike<T> arrayLike) {
    return from(Js.<FromArrayLikeUnionType<T>>uncheckedCast(arrayLike));
  }

  @JsOverlay
  public static final <T, R> R[] from(
      String arrayLike, FromMapCallbackFn<T, R> mapFn, Object this_) {
    return from(Js.<FromArrayLikeUnionType<T>>uncheckedCast(arrayLike), mapFn, this_);
  }

  @JsOverlay
  public static final <T, R> R[] from(String arrayLike, FromMapCallbackFn<T, R> mapFn) {
    return from(Js.<FromArrayLikeUnionType<T>>uncheckedCast(arrayLike), mapFn);
  }

  @JsOverlay
  public static final <T, R> R[] from(String arrayLike) {
    return from(Js.<FromArrayLikeUnionType<T>>uncheckedCast(arrayLike));
  }

  public static native boolean isArray(Object arr);

  public static native Object[] observe(Object[] array, Function callback);

  public static native <T> T[] of(T... var_args);

  public static native Object[] unobserve(Object[] array, Function callback);

  public double index;
  public String input;
  public double length;

  public Array(Object... items) {}

  public native T[] concat(T... items);

  public native JsArrayLike<T> copyWithin(double target, double start, double end);

  public native JsArrayLike<T> copyWithin(double target, double start);

  public native IteratorIterable<EntriesIteratorIterableTypeParameterArrayUnionType[]> entries();

  public native boolean every(EveryCallbackFn<T> callback, Object thisobj);

  public native boolean every(EveryCallbackFn<T> callback);

  public native JsArrayLike<T> fill(T value, double begin, double end);

  public native JsArrayLike<T> fill(T value, double begin);

  public native JsArrayLike<T> fill(T value);

  public native T[] filter(FilterCallbackFn<T> callback, Object thisobj);

  public native T[] filter(FilterCallbackFn<T> callback);

  public native T find(FindPredicateCallbackFn<T> predicate, Object this_);

  public native T find(FindPredicateCallbackFn<T> predicate);

  public native double findIndex(FindIndexPredicateCallbackFn<T> predicate, Object this_);

  public native double findIndex(FindIndexPredicateCallbackFn<T> predicate);

  public native void forEach(ForEachCallbackFn<T> callback, Object thisobj);

  public native void forEach(ForEachCallbackFn<T> callback);

  public native boolean includes(T searchElement, double fromIndex);

  public native boolean includes(T searchElement);

  public native double indexOf(T obj, double fromIndex);

  public native double indexOf(T obj);

  public native String join();

  public native String join(Object separator);

  public native IteratorIterable<Double> keys();

  public native double lastIndexOf(T obj, double fromIndex);

  public native double lastIndexOf(T obj);

  public native <R> R[] map(MapCallbackFn<T, R> callback, Object thisobj);

  public native <R> R[] map(MapCallbackFn<T, R> callback);

  public native T pop();

  public native double push(T... var_args);

  public native <R> R reduce(ReduceCallbackFn<T, R> callback, Object initialValue);

  public native <R> R reduce(ReduceCallbackFn<T, R> callback);

  public native <R> R reduceRight(ReduceRightCallbackFn<T, R> callback, Object initialValue);

  public native <R> R reduceRight(ReduceRightCallbackFn<T, R> callback);

  public native T[] reverse();

  public native T shift();

  public native T[] slice();

  public native T[] slice(double begin, double end);

  public native T[] slice(double begin);

  public native boolean some(SomeCallbackFn<T> callback, Object thisobj);

  public native boolean some(SomeCallbackFn<T> callback);

  public native T[] sort();

  public native T[] sort(SortCompareFunctionCallbackFn<T> compareFunction);

  public native T[] splice(double index, double howMany, T... var_args);

  public native String toSource();

  public native String toString();

  public native double unshift(T... var_args);
}
