/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.critical;

import org.jboss.logging.Logger;

public class CriticalMeasure {
    private static final Logger logger = Logger.getLogger(CriticalMeasure.class);
    private volatile long timeEnter;
    private volatile long timeLeft;

    public void enterCritical() {
        this.timeEnter = System.currentTimeMillis();
    }

    public void leaveCritical() {
        this.timeLeft = System.currentTimeMillis();
    }

    public boolean isExpired(long timeout) {
        if (this.timeEnter > this.timeLeft) {
            return System.currentTimeMillis() - this.timeEnter > timeout;
        }
        return false;
    }

    public long enterTime() {
        return this.timeEnter;
    }

    public long leaveTime() {
        return this.timeLeft;
    }
}

