/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.actors;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public interface ArtemisExecutor
extends Executor {
    public static ArtemisExecutor delegate(final Executor executor) {
        return new ArtemisExecutor(){

            @Override
            public void execute(Runnable command) {
                executor.execute(command);
            }
        };
    }

    default public boolean flush() {
        return this.flush(30L, TimeUnit.SECONDS);
    }

    default public boolean flush(long timeout, TimeUnit unit) {
        final CountDownLatch latch = new CountDownLatch(1);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                latch.countDown();
            }
        };
        this.execute(runnable);
        try {
            return latch.await(timeout, unit);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    default public boolean isFlushed() {
        return this.flush(100L, TimeUnit.MILLISECONDS);
    }
}

