/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.daemon.ssh;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.ReceivePack;
import org.eclipse.jgit.transport.resolver.ReceivePackFactory;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProvider;
import org.uberfire.java.nio.fs.jgit.daemon.ssh.BaseGitCommand;
import org.uberfire.java.nio.security.FileSystemAuthorizer;
import org.uberfire.java.nio.security.FileSystemUser;

public class GitReceiveCommand
extends BaseGitCommand {
    private final ReceivePackFactory<BaseGitCommand> receivePackFactory;

    public GitReceiveCommand(String command, JGitFileSystemProvider.RepositoryResolverImpl<BaseGitCommand> repositoryResolver, FileSystemAuthorizer fileSystemAuthorizer, ReceivePackFactory<BaseGitCommand> receivePackFactory, ExecutorService executorService) {
        super(command, fileSystemAuthorizer, repositoryResolver, executorService);
        this.receivePackFactory = receivePackFactory;
    }

    @Override
    protected String getCommandName() {
        return "git-receive-pack";
    }

    @Override
    protected void execute(FileSystemUser user, Repository repository, InputStream in, OutputStream out, OutputStream err, JGitFileSystem fileSystem) {
        try {
            ReceivePack rp = this.receivePackFactory.create((Object)this, repository);
            rp.receive(in, out, err);
            rp.setPostReceiveHook((rp1, commands) -> {
                fileSystem.getGit().gc();
                fileSystem.resetCommitCount();
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

