/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.DeleteBranchCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.GarbageCollectCommand;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.RemoteListCommand;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.internal.ketch.KetchLeader;
import org.eclipse.jgit.internal.ketch.KetchLeaderCache;
import org.eclipse.jgit.internal.storage.reftree.RefTreeDatabase;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RefSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.config.ConfigProperties;
import org.uberfire.commons.data.Pair;
import org.uberfire.java.nio.base.FileDiff;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.fs.jgit.JGitPathImpl;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.ThrowableSupplier;
import org.uberfire.java.nio.fs.jgit.util.commands.BlobAsInputStream;
import org.uberfire.java.nio.fs.jgit.util.commands.CherryPick;
import org.uberfire.java.nio.fs.jgit.util.commands.Commit;
import org.uberfire.java.nio.fs.jgit.util.commands.ConvertRefTree;
import org.uberfire.java.nio.fs.jgit.util.commands.CreateBranch;
import org.uberfire.java.nio.fs.jgit.util.commands.DeleteBranch;
import org.uberfire.java.nio.fs.jgit.util.commands.DiffBranches;
import org.uberfire.java.nio.fs.jgit.util.commands.Fetch;
import org.uberfire.java.nio.fs.jgit.util.commands.GarbageCollector;
import org.uberfire.java.nio.fs.jgit.util.commands.GetFirstCommit;
import org.uberfire.java.nio.fs.jgit.util.commands.GetLastCommit;
import org.uberfire.java.nio.fs.jgit.util.commands.GetPathInfo;
import org.uberfire.java.nio.fs.jgit.util.commands.GetRef;
import org.uberfire.java.nio.fs.jgit.util.commands.GetTreeFromRef;
import org.uberfire.java.nio.fs.jgit.util.commands.ListCommits;
import org.uberfire.java.nio.fs.jgit.util.commands.ListDiffs;
import org.uberfire.java.nio.fs.jgit.util.commands.ListPathContent;
import org.uberfire.java.nio.fs.jgit.util.commands.ListRefs;
import org.uberfire.java.nio.fs.jgit.util.commands.Merge;
import org.uberfire.java.nio.fs.jgit.util.commands.PathUtil;
import org.uberfire.java.nio.fs.jgit.util.commands.Push;
import org.uberfire.java.nio.fs.jgit.util.commands.RefTreeUpdateCommand;
import org.uberfire.java.nio.fs.jgit.util.commands.ResolveObjectIds;
import org.uberfire.java.nio.fs.jgit.util.commands.ResolveRevCommit;
import org.uberfire.java.nio.fs.jgit.util.commands.SimpleRefUpdateCommand;
import org.uberfire.java.nio.fs.jgit.util.commands.Squash;
import org.uberfire.java.nio.fs.jgit.util.commands.SyncRemote;
import org.uberfire.java.nio.fs.jgit.util.commands.UpdateRemoteConfig;
import org.uberfire.java.nio.fs.jgit.util.model.CommitContent;
import org.uberfire.java.nio.fs.jgit.util.model.CommitInfo;
import org.uberfire.java.nio.fs.jgit.util.model.PathInfo;

public class GitImpl
implements Git {
    private static final Logger LOG = LoggerFactory.getLogger(GitImpl.class);
    private static final String DEFAULT_JGIT_RETRY_SLEEP_TIME = "50";
    private static int JGIT_RETRY_TIMES = GitImpl.initRetryValue();
    private static final int JGIT_RETRY_SLEEP_TIME = GitImpl.initSleepTime();
    private boolean isEnabled = false;
    private org.eclipse.jgit.api.Git git;
    private KetchLeaderCache leaders;
    private final AtomicBoolean isHeadInitialized = new AtomicBoolean(false);

    private static int initSleepTime() {
        ConfigProperties config = new ConfigProperties(System.getProperties());
        return config.get("org.uberfire.nio.git.retry.onfail.sleep", DEFAULT_JGIT_RETRY_SLEEP_TIME).getIntValue();
    }

    private static int initRetryValue() {
        ConfigProperties config = new ConfigProperties(System.getProperties());
        String osName = config.get("os.name", "any").getValue();
        String defaultRetryTimes = osName.toLowerCase().contains("windows") ? "10" : "0";
        try {
            return config.get("org.uberfire.nio.git.retry.onfail.times", defaultRetryTimes).getIntValue();
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }

    public GitImpl(org.eclipse.jgit.api.Git git) {
        this(git, null);
    }

    public GitImpl(org.eclipse.jgit.api.Git git, KetchLeaderCache leaders) {
        this.git = git;
        this.leaders = leaders;
    }

    @Override
    public void convertRefTree() {
        try {
            new ConvertRefTree(this).execute();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void deleteRef(Ref ref) {
        new DeleteBranch(this, ref).execute();
    }

    @Override
    public Ref getRef(String ref) {
        return new GetRef(this.git.getRepository(), ref).execute();
    }

    @Override
    public void push(CredentialsProvider credentialsProvider, Pair<String, String> remote, boolean force, Collection<RefSpec> refSpecs) throws InvalidRemoteException {
        new Push(this, credentialsProvider, remote, force, refSpecs).execute();
    }

    @Override
    public void gc() {
        new GarbageCollector(this).execute();
    }

    @Override
    public RevCommit getLastCommit(String refName) {
        return GitImpl.retryIfNeeded(RuntimeException.class, () -> new GetLastCommit((Git)this, refName).execute());
    }

    @Override
    public RevCommit getLastCommit(Ref ref) throws IOException {
        return new GetLastCommit((Git)this, ref).execute();
    }

    @Override
    public List<RevCommit> listCommits(Ref ref, String path) throws IOException, GitAPIException {
        return new ListCommits(this, ref, path).execute();
    }

    @Override
    public List<RevCommit> listCommits(ObjectId startRange, ObjectId endRange) {
        return GitImpl.retryIfNeeded(RuntimeException.class, () -> new ListCommits(this, startRange, endRange).execute());
    }

    @Override
    public Repository getRepository() {
        return this.git.getRepository();
    }

    public DeleteBranchCommand _branchDelete() {
        return this.git.branchDelete();
    }

    public ListBranchCommand _branchList() {
        return this.git.branchList();
    }

    public CreateBranchCommand _branchCreate() {
        return this.git.branchCreate();
    }

    public FetchCommand _fetch() {
        return this.git.fetch();
    }

    public GarbageCollectCommand _gc() {
        return this.git.gc();
    }

    public PushCommand _push() {
        return this.git.push();
    }

    @Override
    public ObjectId getTreeFromRef(String treeRef) {
        return new GetTreeFromRef(this, treeRef).execute();
    }

    @Override
    public void fetch(CredentialsProvider credential, Pair<String, String> remote, Collection<RefSpec> refSpecs) throws InvalidRemoteException {
        new Fetch(this, credential, remote, refSpecs).execute();
    }

    @Override
    public void syncRemote(Pair<String, String> remote) throws InvalidRemoteException {
        new SyncRemote(this, remote).execute();
    }

    @Override
    public List<String> merge(String source, String target) {
        return new Merge(this, source, target).execute();
    }

    @Override
    public void cherryPick(JGitPathImpl target, String ... commits) {
        new CherryPick(this, target.getRefTree(), commits).execute();
    }

    @Override
    public void cherryPick(String targetBranch, String[] commitsIDs) {
        new CherryPick(this, targetBranch, commitsIDs).execute();
    }

    @Override
    public void createRef(String source, String target) {
        new CreateBranch(this, source, target).execute();
    }

    @Override
    public List<FileDiff> diffRefs(String branchA, String branchB) {
        return new DiffBranches(this, branchA, branchB).execute();
    }

    @Override
    public void squash(String branch, String startCommit, String commitMessage) {
        new Squash(this, branch, startCommit, commitMessage).execute();
    }

    public LogCommand _log() {
        return this.git.log();
    }

    @Override
    public boolean commit(String branchName, CommitInfo commitInfo, boolean amend, ObjectId originId, CommitContent content) {
        return new Commit(this, branchName, commitInfo, amend, null, content).execute();
    }

    @Override
    public List<DiffEntry> listDiffs(ObjectId refA, ObjectId refB) {
        return new ListDiffs(this, refA, refB).execute();
    }

    @Override
    public InputStream blobAsInputStream(String treeRef, String path) {
        return GitImpl.retryIfNeeded(NoSuchFileException.class, () -> new BlobAsInputStream(this, treeRef, PathUtil.normalize(path)).execute().get());
    }

    @Override
    public RevCommit getFirstCommit(Ref ref) throws IOException {
        return new GetFirstCommit((Git)this, ref).execute();
    }

    @Override
    public List<Ref> listRefs() {
        return new ListRefs(this.git.getRepository()).execute();
    }

    @Override
    public List<ObjectId> resolveObjectIds(String ... commits) {
        return new ResolveObjectIds(this, commits).execute();
    }

    @Override
    public RevCommit resolveRevCommit(ObjectId objectId) throws IOException {
        return new ResolveRevCommit(this.git.getRepository(), objectId).execute();
    }

    @Override
    public List<RefSpec> updateRemoteConfig(Pair<String, String> remote, Collection<RefSpec> refSpecs) throws IOException, URISyntaxException {
        return new UpdateRemoteConfig(this, remote, refSpecs).execute();
    }

    public AddCommand _add() {
        return this.git.add();
    }

    public CommitCommand _commit() {
        return this.git.commit();
    }

    public RemoteListCommand _remoteList() {
        return this.git.remoteList();
    }

    public static CloneCommand _cloneRepository() {
        return org.eclipse.jgit.api.Git.cloneRepository();
    }

    @Override
    public PathInfo getPathInfo(String branchName, String path) {
        return GitImpl.retryIfNeeded(RuntimeException.class, () -> new GetPathInfo(this, branchName, path).execute());
    }

    @Override
    public List<PathInfo> listPathContent(String branchName, String path) {
        return GitImpl.retryIfNeeded(RuntimeException.class, () -> new ListPathContent(this, branchName, path).execute());
    }

    @Override
    public boolean isHEADInitialized() {
        return this.isHeadInitialized.get();
    }

    @Override
    public void setHeadAsInitialized() {
        this.isHeadInitialized.set(true);
    }

    @Override
    public void refUpdate(String branch, RevCommit commit) throws IOException, ConcurrentRefUpdateException {
        if (this.getRepository().getRefDatabase() instanceof RefTreeDatabase) {
            new RefTreeUpdateCommand(this, branch, commit).execute();
        } else {
            new SimpleRefUpdateCommand(this, branch, commit).execute();
        }
    }

    @Override
    public KetchLeader getKetchLeader() {
        try {
            return this.leaders.get(this.getRepository());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isKetchEnabled() {
        return this.isEnabled;
    }

    @Override
    public void enableKetch() {
        this.isEnabled = true;
    }

    @Override
    public void updateRepo(Repository repo) {
        this.git = new org.eclipse.jgit.api.Git(repo);
    }

    @Override
    public void updateLeaders(KetchLeaderCache leaders) {
        this.leaders = leaders;
    }

    static void setRetryTimes(int retryTimes) {
        JGIT_RETRY_TIMES = retryTimes;
    }

    public static <E extends Throwable, T> T retryIfNeeded(Class<E> eclazz, ThrowableSupplier<T> supplier) throws E {
        int i = 0;
        while (true) {
            try {
                return supplier.get();
            }
            catch (Throwable ex) {
                if (i < JGIT_RETRY_TIMES - 1) {
                    try {
                        Thread.sleep(JGIT_RETRY_SLEEP_TIME);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } else {
                    LOG.error(String.format("Unexpected exception (%d/%d).", i + 1, JGIT_RETRY_TIMES), ex);
                    if (ex.getClass().isAssignableFrom(eclazz)) {
                        throw ex;
                    }
                    throw new RuntimeException(ex);
                }
                LOG.debug(String.format("Unexpected exception (%d/%d).", i + 1, JGIT_RETRY_TIMES), ex);
                if (++i < JGIT_RETRY_TIMES) continue;
                return null;
            }
            break;
        }
    }
}

