/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.impl.authz;

import java.util.HashMap;
import java.util.Map;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.GroupImpl;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.uberfire.security.authz.AuthorizationPolicy;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionType;
import org.uberfire.security.authz.PermissionTypeRegistry;
import org.uberfire.security.impl.authz.DefaultAuthorizationPolicy;

public class AuthorizationPolicyBuilder {
    private PermissionTypeRegistry permissionTypeRegistry;
    private DefaultAuthorizationPolicy policy = new DefaultAuthorizationPolicy();
    private Map<String, Role> roles = new HashMap<String, Role>();
    private Map<String, Group> groups = new HashMap<String, Group>();
    private transient Role _currentRole = null;
    private transient Group _currentGroup = null;

    public AuthorizationPolicyBuilder(PermissionTypeRegistry permissionTypeRegistry) {
        this.permissionTypeRegistry = permissionTypeRegistry;
    }

    public AuthorizationPolicyBuilder bydefault() {
        this._currentRole = null;
        this._currentGroup = null;
        return this;
    }

    public AuthorizationPolicyBuilder role(String role) {
        this._currentGroup = null;
        this._currentRole = this.roles.get(role);
        if (this._currentRole == null) {
            this._currentRole = new RoleImpl(role);
            this.roles.put(role, this._currentRole);
        }
        return this;
    }

    public AuthorizationPolicyBuilder role(String role, String home) {
        this.role(role);
        this.home(home);
        return this;
    }

    public AuthorizationPolicyBuilder role(String role, int priority) {
        this.role(role);
        this.priority(priority);
        return this;
    }

    public AuthorizationPolicyBuilder role(String role, int priority, String home) {
        this.role(role);
        this.priority(priority);
        this.home(home);
        return this;
    }

    public AuthorizationPolicyBuilder group(String group) {
        this._currentRole = null;
        this._currentGroup = this.groups.get(group);
        if (this._currentGroup == null) {
            this._currentGroup = new GroupImpl(group);
            this.groups.put(group, this._currentGroup);
        }
        return this;
    }

    public AuthorizationPolicyBuilder group(String group, int priority, String home) {
        this.group(group);
        this.priority(priority);
        this.home(home);
        return this;
    }

    public AuthorizationPolicyBuilder group(String group, int priority) {
        this.group(group);
        this.priority(priority);
        return this;
    }

    public AuthorizationPolicyBuilder group(String group, String home) {
        this.group(group);
        this.home(home);
        return this;
    }

    public AuthorizationPolicyBuilder permission(String name, Boolean granted) {
        PermissionType type = this.permissionTypeRegistry.resolve(name);
        Permission permission = type.createPermission(name, granted);
        if (this._currentRole != null) {
            this.policy.addPermission(this._currentRole, permission);
        } else if (this._currentGroup != null) {
            this.policy.addPermission(this._currentGroup, permission);
        } else {
            this.policy.addPermission(permission);
        }
        return this;
    }

    public AuthorizationPolicyBuilder description(String description) {
        if (this._currentRole != null) {
            this.policy.setRoleDescription(this._currentRole, description);
        } else if (this._currentGroup != null) {
            this.policy.setGroupDescription(this._currentGroup, description);
        } else {
            throw new IllegalStateException("Invoke role() or group() first");
        }
        return this;
    }

    public AuthorizationPolicyBuilder priority(int priority) {
        if (this._currentRole != null) {
            this.policy.setPriority(this._currentRole, priority);
        } else if (this._currentGroup != null) {
            this.policy.setPriority(this._currentGroup, priority);
        } else {
            throw new IllegalStateException("Invoke role() or group() first");
        }
        return this;
    }

    public AuthorizationPolicyBuilder home(String homePerspective) {
        if (this._currentRole != null) {
            this.policy.setHomePerspective(this._currentRole, homePerspective);
        } else if (this._currentGroup != null) {
            this.policy.setHomePerspective(this._currentGroup, homePerspective);
        } else {
            this.policy.setHomePerspective(homePerspective);
        }
        return this;
    }

    public AuthorizationPolicy build() {
        return this.policy;
    }
}

