/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.widgets;

import com.google.common.base.Strings;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.TakesValue;
import java.util.function.Consumer;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.Document;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Option;
import org.jboss.errai.common.client.dom.OptionsCollection;

@Dependent
public class Select
implements IsElement,
TakesValue<String> {
    @Inject
    private Document document;
    @Inject
    private org.jboss.errai.common.client.dom.Select select;

    public HTMLElement getElement() {
        return this.select;
    }

    public void addOption(String text) {
        this.addOption(text, text);
    }

    public void addOption(String text, String value) {
        this.addOption(text, value, false);
    }

    public void addOption(String text, String value, Boolean selected) {
        this.addOption(text, null, value, selected);
    }

    public void addOption(String text, String subText, String value, Boolean selected) {
        Option option = (Option)this.document.createElement("option");
        option.setText(text);
        option.setValue(value);
        option.setSelected(selected.booleanValue());
        if (!Strings.isNullOrEmpty((String)subText)) {
            option.setAttribute("data-subtext", subText);
        }
        this.select.add((HTMLElement)option);
    }

    public OptionsCollection getOptions() {
        return this.select.getOptions();
    }

    public void removeAllOptions() {
        this.removeAllOptions((HTMLElement)this.select);
    }

    public void refresh() {
        this.refresh(null);
    }

    public void refresh(Consumer<Select> consumer) {
        Scheduler.get().scheduleDeferred(() -> {
            if (consumer != null) {
                consumer.accept(this);
            }
            this.refreshElement((HTMLElement)this.select);
        });
    }

    public String getValue() {
        return this.getValue((HTMLElement)this.select);
    }

    public void setValue(String value) {
        this.setValue((HTMLElement)this.select, value);
    }

    public void enable() {
        this.enable((HTMLElement)this.select);
        this.refresh();
    }

    public void disable() {
        this.disable((HTMLElement)this.select);
        this.refresh();
    }

    public void setTitle(String title) {
        this.select.setTitle(title);
    }

    public void setLiveSearch(Boolean liveSearch) {
        this.select.setAttribute("data-live-search", String.valueOf(liveSearch));
    }

    public void setWidth(String width) {
        this.select.setAttribute("data-width", width);
    }

    private native void refreshElement(HTMLElement var1);

    private native String getValue(HTMLElement var1);

    private native void setValue(HTMLElement var1, String var2);

    private native void disable(HTMLElement var1);

    private native void enable(HTMLElement var1);

    private native void removeAllOptions(HTMLElement var1);
}

