/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.engines.htmlextractor.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.clerezza.rdf.core.BNode;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.Triple;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.impl.SimpleMGraph;
import org.apache.clerezza.rdf.core.impl.TripleImpl;
import org.apache.stanbol.enhancer.servicesapi.helper.EnhancementEngineHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClerezzaRDFUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ClerezzaRDFUtils.class);

    public static void urifyBlankNodes(MGraph model) {
        HashMap<BNode, UriRef> blankNodeMap = new HashMap<BNode, UriRef>();
        SimpleMGraph remove = new SimpleMGraph();
        SimpleMGraph add = new SimpleMGraph();
        for (Triple t : model) {
            UriRef ru;
            NonLiteral subj = t.getSubject();
            Resource obj = t.getObject();
            UriRef pred = t.getPredicate();
            boolean match = false;
            if (subj instanceof BNode) {
                match = true;
                ru = (UriRef)blankNodeMap.get(subj);
                if (ru == null) {
                    ru = ClerezzaRDFUtils.createRandomUri();
                    blankNodeMap.put((BNode)subj, ru);
                }
                subj = ru;
            }
            if (obj instanceof BNode) {
                match = true;
                ru = (UriRef)blankNodeMap.get(obj);
                if (ru == null) {
                    ru = ClerezzaRDFUtils.createRandomUri();
                    blankNodeMap.put((BNode)obj, ru);
                }
                obj = ru;
            }
            if (!match) continue;
            remove.add((Object)t);
            add.add((Object)new TripleImpl(subj, pred, obj));
        }
        model.removeAll((Collection)remove);
        model.addAll((Collection)add);
    }

    public static UriRef createRandomUri() {
        return new UriRef("urn:rnd:" + EnhancementEngineHelper.randomUUID());
    }

    public static void makeConnected(MGraph model, NonLiteral root, UriRef property) {
        Set<NonLiteral> roots = ClerezzaRDFUtils.findRoots(model);
        LOG.debug("Roots: {}", (Object)roots.size());
        boolean found = roots.remove(root);
        for (NonLiteral n : roots) {
            model.add((Object)new TripleImpl(root, property, (Resource)n));
        }
    }

    public static Set<NonLiteral> findRoots(MGraph model) {
        HashSet<NonLiteral> roots = new HashSet<NonLiteral>();
        HashSet<NonLiteral> visited = new HashSet<NonLiteral>();
        for (Triple t : model) {
            NonLiteral subj = t.getSubject();
            ClerezzaRDFUtils.findRoot(model, subj, roots, visited);
        }
        return roots;
    }

    private static void findRoot(MGraph model, NonLiteral node, Set<NonLiteral> roots, Set<NonLiteral> visited) {
        if (visited.contains(node)) {
            return;
        }
        visited.add(node);
        Iterator it = model.filter(null, null, (Resource)node);
        if (!it.hasNext()) {
            roots.add(node);
            LOG.debug("Root found: {}", (Object)node);
            return;
        }
        while (it.hasNext()) {
            Triple t = (Triple)it.next();
            NonLiteral subj = t.getSubject();
            ClerezzaRDFUtils.findRoot(model, subj, roots, visited);
        }
    }
}

