/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.menu;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import org.gwtbootstrap3.client.ui.Anchor;
import org.gwtbootstrap3.client.ui.AnchorButton;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.ListDropDown;
import org.gwtbootstrap3.client.ui.ListItem;
import org.gwtbootstrap3.client.ui.base.AbstractListItem;
import org.gwtbootstrap3.client.ui.constants.Pull;
import org.gwtbootstrap3.client.ui.constants.Toggle;
import org.gwtbootstrap3.client.ui.html.UnorderedList;
import org.uberfire.client.views.pfly.menu.WorkbenchMenuNavBarView;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.menu.MenuPosition;

@ApplicationScoped
public class WorkbenchMenuStandardNavBarView
extends WorkbenchMenuNavBarView {
    @Override
    @PostConstruct
    protected void setup() {
        super.setup();
        this.addStyleName("navbar-primary persistent-secondary");
    }

    @Override
    public void addMenuItem(String id, String label, String parentId, final Command command, MenuPosition position) {
        AnchorListItem menuItem = (AnchorListItem)GWT.create(AnchorListItem.class);
        menuItem.setText(label);
        if (command != null) {
            menuItem.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    command.execute();
                }
            });
        }
        this.getMenuItemWidgetMap().put(id, (ComplexPanel)menuItem);
        if (parentId == null) {
            this.positionMenuItem((AbstractListItem)menuItem, position);
            this.navbarNav.add((Widget)menuItem);
        } else {
            ComplexPanel parent = this.getMenuItemWidgetMap().get(parentId);
            if (parent != null) {
                parent.add((Widget)menuItem);
            }
        }
    }

    @Override
    public void addCustomMenuItem(Widget menu, MenuPosition position) {
        this.positionMenuItem(menu, position);
        this.navbarNav.add(menu);
    }

    @Override
    public void addGroupMenuItem(String id, String label, MenuPosition position) {
        ListDropDown listDropDown = (ListDropDown)GWT.create(ListDropDown.class);
        AnchorButton anchor = (AnchorButton)GWT.create(AnchorButton.class);
        anchor.setDataToggle(Toggle.DROPDOWN);
        anchor.setText(label);
        DropDownMenu dropDownMenu = (DropDownMenu)GWT.create(DropDownMenu.class);
        listDropDown.add((Widget)anchor);
        listDropDown.add((Widget)dropDownMenu);
        this.positionMenuItem((AbstractListItem)listDropDown, position);
        this.navbarNav.add((Widget)listDropDown);
        this.getMenuItemWidgetMap().put(id, (ComplexPanel)dropDownMenu);
    }

    @Override
    public void addContextMenuItem(String menuItemId, String id, String label, String parentId, final Command command, MenuPosition position) {
        AnchorListItem menuItem = (AnchorListItem)GWT.create(AnchorListItem.class);
        menuItem.setText(label);
        if (command != null) {
            menuItem.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    command.execute();
                }
            });
        }
        this.positionMenuItem((AbstractListItem)menuItem, position);
        ComplexPanel contextContainer = this.getMenuItemContextWidgetMap().get(parentId);
        if (contextContainer == null) {
            contextContainer = this.getContextContainer(menuItemId);
        }
        contextContainer.add((Widget)menuItem);
        this.getMenuItemContextWidgetMap().put(id, (ComplexPanel)menuItem);
    }

    @Override
    public void addContextGroupMenuItem(String menuItemId, String id, String label, MenuPosition position) {
        ListDropDown listDropDown = (ListDropDown)GWT.create(ListDropDown.class);
        listDropDown.setStyleName("dropdown-submenu");
        Anchor anchor = (Anchor)GWT.create(Anchor.class);
        anchor.addStyleName("dropdown-toggle");
        anchor.setDataToggle(Toggle.DROPDOWN);
        anchor.setText(label);
        DropDownMenu dropDownMenu = (DropDownMenu)GWT.create(DropDownMenu.class);
        listDropDown.add((Widget)anchor);
        listDropDown.add((Widget)dropDownMenu);
        this.positionMenuItem((AbstractListItem)listDropDown, position);
        ComplexPanel contextContainer = this.getMenuItemContextWidgetMap().get(menuItemId);
        if (contextContainer == null) {
            contextContainer = this.getContextContainer(menuItemId);
        }
        contextContainer.add((Widget)listDropDown);
        this.getMenuItemContextWidgetMap().put(id, (ComplexPanel)dropDownMenu);
    }

    @Override
    public void clearContextMenu() {
        super.clearContextMenu();
        for (ComplexPanel contextContainer : this.getContextContainerWidgetMap().values()) {
            contextContainer.clear();
            contextContainer.removeFromParent();
        }
        this.getContextContainerWidgetMap().clear();
    }

    void positionMenuItem(AbstractListItem menuItem, MenuPosition position) {
        if (MenuPosition.RIGHT.equals((Object)position)) {
            menuItem.setPull(Pull.RIGHT);
        }
    }

    void positionMenuItem(Widget menu, MenuPosition position) {
        if (MenuPosition.RIGHT.equals((Object)position)) {
            menu.getElement().getStyle().setFloat(Style.Float.RIGHT);
        }
    }

    private ComplexPanel getContextContainer(String menuItemId) {
        ComplexPanel contextContainer = this.getContextContainerWidgetMap().get(menuItemId);
        if (contextContainer == null) {
            contextContainer = (ComplexPanel)GWT.create(UnorderedList.class);
            contextContainer.addStyleName("nav navbar-nav navbar-persistent");
            contextContainer.addStyleName("uf-perspective-context-menu");
            contextContainer.setVisible(false);
            this.getContextContainerWidgetMap().put(menuItemId, contextContainer);
        }
        return contextContainer;
    }

    private void addContextMenusToContainer(String menuItemId, ComplexPanel menuItemWidget) {
        ComplexPanel container;
        ComplexPanel contextContainer = this.getContextContainerWidgetMap().get(menuItemId);
        Object object = container = menuItemWidget.getParent().getParent() instanceof ListDropDown ? (ListDropDown)menuItemWidget.getParent().getParent() : menuItemWidget;
        if (contextContainer != null && container.getWidgetIndex((Widget)contextContainer) == -1) {
            container.add((Widget)contextContainer);
        }
    }

    @Override
    public void selectMenuItem(String id) {
        ComplexPanel menuItemWidget = this.getMenuItemWidgetMap().get(id);
        if (menuItemWidget == null) {
            menuItemWidget = (ComplexPanel)GWT.create(ListItem.class);
            menuItemWidget.addStyleName("uf-perspective-context-menu-empty");
            this.getMenuItemWidgetMap().put(id, menuItemWidget);
            this.navbarNav.add((Widget)menuItemWidget);
        }
        super.selectMenuItem(id);
        this.addContextMenusToContainer(id, menuItemWidget);
        for (Map.Entry<String, ComplexPanel> context : this.getContextContainerWidgetMap().entrySet()) {
            if (context.getKey().equals(id)) {
                context.getValue().setVisible(true);
                context.getValue().getParent().addStyleName("uf-perspective-context-menu-container");
                continue;
            }
            context.getValue().setVisible(false);
        }
    }

    @Override
    protected void selectElement(ComplexPanel item) {
        this.iterateWidgets((ComplexPanel)this.navbarNav);
        if (item == null) {
            return;
        }
        item.addStyleName("active");
        if (item.getParent() != null && item.getParent().getParent() instanceof ListDropDown) {
            item.getParent().getParent().addStyleName("active");
        }
    }

    private void iterateWidgets(ComplexPanel widget) {
        widget.removeStyleName("active");
        widget.removeStyleName("uf-perspective-context-menu-container");
        for (Widget next : widget) {
            if (!(next instanceof ComplexPanel)) continue;
            this.iterateWidgets((ComplexPanel)next);
        }
    }
}

