/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Collection;
import org.apache.sshd.common.config.keys.KeyEntryResolver;
import org.apache.sshd.common.config.keys.PublicKeyEntryResolver;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;

public interface PublicKeyEntryDecoder<PUB extends PublicKey, PRV extends PrivateKey>
extends KeyEntryResolver<PUB, PRV>,
PublicKeyEntryResolver {
    @Override
    default public PublicKey resolve(String keyType, byte[] keyData) throws IOException, GeneralSecurityException {
        ValidateUtils.checkNotNullAndNotEmpty(keyType, "No key type provided");
        Collection<String> supported = this.getSupportedTypeNames();
        if (GenericUtils.size(supported) > 0 && supported.contains(keyType)) {
            return this.decodePublicKey(keyData);
        }
        throw new InvalidKeySpecException("resolve(" + keyType + ") not in listed supported types: " + supported);
    }

    default public PUB decodePublicKey(byte ... keyData) throws IOException, GeneralSecurityException {
        return this.decodePublicKey(keyData, 0, NumberUtils.length(keyData));
    }

    default public PUB decodePublicKey(byte[] keyData, int offset, int length) throws IOException, GeneralSecurityException {
        if (length <= 0) {
            return null;
        }
        try (ByteArrayInputStream stream = new ByteArrayInputStream(keyData, offset, length);){
            PUB PUB = this.decodePublicKey(stream);
            return PUB;
        }
    }

    default public PUB decodePublicKey(InputStream keyData) throws IOException, GeneralSecurityException {
        String type = KeyEntryResolver.decodeString(keyData);
        if (GenericUtils.isEmpty(type)) {
            throw new StreamCorruptedException("Missing key type string");
        }
        Collection<String> supported = this.getSupportedTypeNames();
        if (GenericUtils.isEmpty(supported) || !supported.contains(type)) {
            throw new InvalidKeySpecException("Reported key type (" + type + ") not in supported list: " + supported);
        }
        return this.decodePublicKey(type, keyData);
    }

    public PUB decodePublicKey(String var1, InputStream var2) throws IOException, GeneralSecurityException;

    public String encodePublicKey(OutputStream var1, PUB var2) throws IOException;
}

